/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.SelectionQuery;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.data.jpa.provider.HibernateUtils;
import org.springframework.data.jpa.provider.JpaClassUtils;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.provider.QueryComment;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.util.CloseableIterator;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class PersistenceProvider
extends Enum<PersistenceProvider>
implements QueryExtractor,
ProxyIdAccessor,
QueryComment {
    public static final /* enum */ PersistenceProvider HIBERNATE;
    public static final /* enum */ PersistenceProvider ECLIPSELINK;
    public static final /* enum */ PersistenceProvider GENERIC_JPA;
    @Nullable
    private static final Class<?> typedParameterValueClass;
    private static final Collection<PersistenceProvider> ALL;
    private static final ConcurrentReferenceHashMap<Class<?>, PersistenceProvider> CACHE;
    final Iterable<String> entityManagerFactoryClassNames;
    private final Iterable<String> metamodelClassNames;
    private final boolean present;
    private static final /* synthetic */ PersistenceProvider[] ENUM$VALUES;

    static {
        Class type;
        HIBERNATE = new PersistenceProvider(List.of("org.hibernate.SessionFactory"), List.of("org.hibernate.metamodel.model.domain.JpaMetamodel")){

            @Override
            @Nullable
            public String extractQueryString(Object query) {
                return HibernateUtils.getHibernateQuery(query);
            }

            @Override
            public boolean isNativeQuery(Object query) {
                return HibernateUtils.isNativeQuery(query);
            }

            @Override
            public String getCountQueryPlaceholder() {
                return "*";
            }

            @Override
            public boolean shouldUseAccessorFor(Object entity) {
                return entity instanceof HibernateProxy;
            }

            @Override
            public Object getIdentifierFrom(Object entity) {
                return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
            }

            @Override
            public <T> Set<SingularAttribute<? super T, ?>> getIdClassAttributes(IdentifiableType<T> type) {
                return type.hasSingleIdAttribute() ? Collections.emptySet() : super.getIdClassAttributes(type);
            }

            @Override
            public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
                return new HibernateScrollableResultsIterator(jpaQuery);
            }

            @Override
            public String getCommentHintKey() {
                return "org.hibernate.comment";
            }

            @Override
            public long getResultCount(Query resultQuery, LongSupplier countSupplier) {
                if (TransactionSynchronizationManager.isActualTransactionActive() && resultQuery instanceof SelectionQuery) {
                    SelectionQuery sq = (SelectionQuery)resultQuery;
                    return sq.getResultCount();
                }
                return super.getResultCount(resultQuery, countSupplier);
            }
        };
        ECLIPSELINK = new PersistenceProvider(List.of("org.eclipse.persistence.jpa.JpaEntityManagerFactory"), List.of("org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl")){

            @Override
            public String extractQueryString(Object query) {
                if (query instanceof JpaQuery) {
                    JpaQuery jpaQuery = (JpaQuery)query;
                    DatabaseQuery databaseQuery = jpaQuery.getDatabaseQuery();
                    if (StringUtils.hasText((String)databaseQuery.getJPQLString())) {
                        return databaseQuery.getJPQLString();
                    }
                    if (StringUtils.hasText((String)databaseQuery.getSQLString())) {
                        return databaseQuery.getSQLString();
                    }
                }
                return "";
            }

            @Override
            public boolean isNativeQuery(Object query) {
                if (query instanceof JpaQuery) {
                    JpaQuery jpaQuery = (JpaQuery)query;
                    DatabaseQueryMechanism call = jpaQuery.getDatabaseQuery().getQueryMechanism();
                    return !(call instanceof JPQLCallQueryMechanism);
                }
                return false;
            }

            @Override
            public boolean shouldUseAccessorFor(Object entity) {
                return false;
            }

            @Override
            @Nullable
            public Object getIdentifierFrom(Object entity) {
                return null;
            }

            @Override
            public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
                return new EclipseLinkScrollableResultsIterator<Object>(jpaQuery);
            }

            @Override
            public String getCommentHintKey() {
                return "eclipselink.sql.hint";
            }

            @Override
            public String getCommentHintValue(String comment) {
                return "/* " + comment + " */";
            }
        };
        GENERIC_JPA = new PersistenceProvider(List.of("jakarta.persistence.EntityManagerFactory"), (Collection)Collections.emptySet()){

            @Override
            @Nullable
            public String extractQueryString(Object query) {
                return null;
            }

            @Override
            public boolean isNativeQuery(Object query) {
                return false;
            }

            @Override
            public boolean canExtractQuery() {
                return false;
            }

            @Override
            public boolean shouldUseAccessorFor(Object entity) {
                return false;
            }

            @Override
            @Nullable
            public Object getIdentifierFrom(Object entity) {
                return null;
            }

            @Override
            @Nullable
            public String getCommentHintKey() {
                return null;
            }
        };
        ENUM$VALUES = new PersistenceProvider[]{HIBERNATE, ECLIPSELINK, GENERIC_JPA};
        try {
            type = ClassUtils.forName((String)"org.hibernate.query.TypedParameterValue", (ClassLoader)PersistenceProvider.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            type = null;
        }
        typedParameterValueClass = type;
        ALL = List.of(HIBERNATE, ECLIPSELINK, GENERIC_JPA);
        CACHE = new ConcurrentReferenceHashMap();
    }

    private PersistenceProvider(Collection<String> entityManagerFactoryClassNames, Collection<String> metamodelClassNames) {
        this.entityManagerFactoryClassNames = entityManagerFactoryClassNames;
        this.metamodelClassNames = metamodelClassNames;
        this.present = Stream.concat(entityManagerFactoryClassNames.stream(), metamodelClassNames.stream()).anyMatch(it -> ClassUtils.isPresent((String)it, (ClassLoader)PersistenceProvider.class.getClassLoader()));
    }

    private static PersistenceProvider cacheAndReturn(Class<?> type, PersistenceProvider provider) {
        CACHE.put(type, (Object)provider);
        return provider;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        return PersistenceProvider.fromEntityManagerFactory(em.getEntityManagerFactory());
    }

    public static PersistenceProvider fromEntityManagerFactory(EntityManagerFactory emf) {
        Assert.notNull((Object)emf, (String)"EntityManagerFactory must not be null");
        EntityManagerFactory unwrapped = emf;
        while (Proxy.isProxyClass(unwrapped.getClass()) || AopUtils.isAopProxy((Object)unwrapped)) {
            if (Proxy.isProxyClass(unwrapped.getClass())) {
                Class<EntityManagerFactory> unwrapTo = Proxy.getInvocationHandler(unwrapped).getClass().getName().contains("org.springframework.orm.jpa.") ? null : EntityManagerFactory.class;
                unwrapped = (EntityManagerFactory)unwrapped.unwrap(unwrapTo);
                continue;
            }
            if (!AopUtils.isAopProxy((Object)unwrapped)) continue;
            unwrapped = (EntityManagerFactory)AopProxyUtils.getSingletonTarget((Object)unwrapped);
        }
        Class<?> entityManagerType = unwrapped.getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(entityManagerType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : ALL) {
            for (String emfClassName : provider.entityManagerFactoryClassNames) {
                if (!JpaClassUtils.isOfType(unwrapped, emfClassName, unwrapped.getClass().getClassLoader())) continue;
                return PersistenceProvider.cacheAndReturn(entityManagerType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(entityManagerType, GENERIC_JPA);
    }

    public static PersistenceProvider fromMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null");
        Class<?> metamodelType = metamodel.getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(metamodelType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        PersistenceProvider[] persistenceProviderArray = PersistenceProvider.values();
        int n = persistenceProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            PersistenceProvider provider = persistenceProviderArray[n2];
            for (String metamodelClassName : provider.metamodelClassNames) {
                if (!JpaClassUtils.isMetamodelOfType(metamodel, metamodelClassName)) continue;
                return PersistenceProvider.cacheAndReturn(metamodelType, provider);
            }
            ++n2;
        }
        return PersistenceProvider.cacheAndReturn(metamodelType, GENERIC_JPA);
    }

    public String getCountQueryPlaceholder() {
        return "x";
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    public <T> Set<SingularAttribute<? super T, ?>> getIdClassAttributes(IdentifiableType<T> type) {
        try {
            return type.getIdClassAttributes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptySet();
        }
    }

    @Nullable
    public static Object unwrapTypedParameterValue(@Nullable Object value) {
        return typedParameterValueClass != null && typedParameterValueClass.isInstance(value) ? null : value;
    }

    public boolean isPresent() {
        return this.present;
    }

    public long getResultCount(Query resultQuery, LongSupplier countSupplier) {
        return countSupplier.getAsLong();
    }

    public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
        throw new UnsupportedOperationException("Streaming results is not implement for this PersistenceProvider: " + this.name());
    }

    public static PersistenceProvider[] values() {
        PersistenceProvider[] persistenceProviderArray = ENUM$VALUES;
        int n = persistenceProviderArray.length;
        PersistenceProvider[] persistenceProviderArray2 = new PersistenceProvider[n];
        System.arraycopy(ENUM$VALUES, 0, persistenceProviderArray2, 0, n);
        return persistenceProviderArray2;
    }

    public static PersistenceProvider valueOf(String string) {
        return Enum.valueOf(PersistenceProvider.class, string);
    }

    static interface Constants {
        public static final String GENERIC_JPA_ENTITY_MANAGER_FACTORY_INTERFACE = "jakarta.persistence.EntityManagerFactory";
        public static final String GENERIC_JPA_ENTITY_MANAGER_INTERFACE = "jakarta.persistence.EntityManager";
        public static final String ECLIPSELINK_ENTITY_MANAGER_FACTORY_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManagerFactory";
        public static final String ECLIPSELINK_ENTITY_MANAGER_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManager";
        public static final String ECLIPSELINK_JPA_METAMODEL_TYPE = "org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl";
        public static final String HIBERNATE_ENTITY_MANAGER_FACTORY_INTERFACE = "org.hibernate.SessionFactory";
        public static final String HIBERNATE_ENTITY_MANAGER_INTERFACE = "org.hibernate.Session";
        public static final String HIBERNATE_JPA_METAMODEL_TYPE = "org.hibernate.metamodel.model.domain.JpaMetamodel";
    }

    private static class EclipseLinkScrollableResultsIterator<T>
    implements CloseableIterator<T> {
        @Nullable
        private final ScrollableCursor scrollableCursor;

        EclipseLinkScrollableResultsIterator(Query jpaQuery) {
            jpaQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            this.scrollableCursor = (ScrollableCursor)jpaQuery.getSingleResult();
        }

        public boolean hasNext() {
            return this.scrollableCursor != null && this.scrollableCursor.hasNext();
        }

        public T next() {
            if (this.scrollableCursor == null) {
                throw new NoSuchElementException("No ScrollableCursor");
            }
            return (T)this.scrollableCursor.next();
        }

        public void close() {
            if (this.scrollableCursor != null) {
                this.scrollableCursor.close();
            }
        }
    }

    private static class HibernateScrollableResultsIterator
    implements CloseableIterator<Object> {
        @Nullable
        private final ScrollableResults<Object[]> scrollableResults;

        HibernateScrollableResultsIterator(Query jpaQuery) {
            org.hibernate.query.Query query = (org.hibernate.query.Query)jpaQuery.unwrap(org.hibernate.query.Query.class);
            this.scrollableResults = query.setReadOnly(TransactionSynchronizationManager.isCurrentTransactionReadOnly()).scroll(ScrollMode.FORWARD_ONLY);
        }

        public Object next() {
            if (this.scrollableResults == null) {
                throw new NoSuchElementException("No ScrollableResults");
            }
            Object[] row = (Object[])this.scrollableResults.get();
            return row.length == 1 ? row[0] : row;
        }

        public boolean hasNext() {
            return this.scrollableResults != null && this.scrollableResults.next();
        }

        public void close() {
            if (this.scrollableResults != null) {
                this.scrollableResults.close();
            }
        }
    }
}

