// Generated from org/springframework/data/jpa/repository/query/Hql.g4 by ANTLR 4.13.2
package org.springframework.data.jpa.repository.query;

/**
 * HQL per https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html#query-language
 *
 * This is a mixture of Hibernate's BNF and missing bits of grammar. There are gaps and inconsistencies in the
 * BNF itself, explained by other fragments of their spec. Additionally, alternate labels are used to provide easier
 * management of complex rules in the generated Visitor. Finally, there are labels applied to rule elements (op=('+'|'-')
 * to simplify the processing.
 *
 * @author Greg Turnquist
 * @author Mark Paluch
 * @author Yannick Brandt
 * @since 3.1
 */

import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.jspecify.annotations.NullUnmarked;
import jakarta.annotation.Generated;

/**
 * This interface defines a complete generic visitor for a parse tree produced
 * by {@link HqlParser}.
 *
 * @param <T> The return type of the visit operation. Use {@link Void} for
 * operations with no return type.
 */
@NullUnmarked
@Generated("HqlVisitor")
interface HqlVisitor<T> extends ParseTreeVisitor<T> {
	/**
	 * Visit a parse tree produced by {@link HqlParser#start}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStart(HqlParser.StartContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#ql_statement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQl_statement(HqlParser.Ql_statementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectStatement(HqlParser.SelectStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#queryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQueryExpression(HqlParser.QueryExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#withClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWithClause(HqlParser.WithClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#cte}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCte(HqlParser.CteContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#searchClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSearchClause(HqlParser.SearchClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#searchSpecifications}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSearchSpecifications(HqlParser.SearchSpecificationsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#searchSpecification}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSearchSpecification(HqlParser.SearchSpecificationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#cycleClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCycleClause(HqlParser.CycleClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#cteAttributes}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCteAttributes(HqlParser.CteAttributesContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#orderedQuery}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrderedQuery(HqlParser.OrderedQueryContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SelectQuery}
	 * labeled alternative in {@link HqlParser#query}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectQuery(HqlParser.SelectQueryContext ctx);
	/**
	 * Visit a parse tree produced by the {@code FromQuery}
	 * labeled alternative in {@link HqlParser#query}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFromQuery(HqlParser.FromQueryContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#queryOrder}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQueryOrder(HqlParser.QueryOrderContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#fromClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFromClause(HqlParser.FromClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityWithJoins}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityWithJoins(HqlParser.EntityWithJoinsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#joinSpecifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinSpecifier(HqlParser.JoinSpecifierContext ctx);
	/**
	 * Visit a parse tree produced by the {@code RootEntity}
	 * labeled alternative in {@link HqlParser#fromRoot}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRootEntity(HqlParser.RootEntityContext ctx);
	/**
	 * Visit a parse tree produced by the {@code RootSubquery}
	 * labeled alternative in {@link HqlParser#fromRoot}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRootSubquery(HqlParser.RootSubqueryContext ctx);
	/**
	 * Visit a parse tree produced by the {@code RootFunction}
	 * labeled alternative in {@link HqlParser#fromRoot}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRootFunction(HqlParser.RootFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#join}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin(HqlParser.JoinContext ctx);
	/**
	 * Visit a parse tree produced by the {@code JoinPath}
	 * labeled alternative in {@link HqlParser#joinTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinPath(HqlParser.JoinPathContext ctx);
	/**
	 * Visit a parse tree produced by the {@code JoinSubquery}
	 * labeled alternative in {@link HqlParser#joinTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinSubquery(HqlParser.JoinSubqueryContext ctx);
	/**
	 * Visit a parse tree produced by the {@code JoinFunctionCall}
	 * labeled alternative in {@link HqlParser#joinTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinFunctionCall(HqlParser.JoinFunctionCallContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#updateStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitUpdateStatement(HqlParser.UpdateStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#targetEntity}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTargetEntity(HqlParser.TargetEntityContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#setClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSetClause(HqlParser.SetClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#assignment}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAssignment(HqlParser.AssignmentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#deleteStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDeleteStatement(HqlParser.DeleteStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#insertStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInsertStatement(HqlParser.InsertStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#targetFields}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTargetFields(HqlParser.TargetFieldsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#valuesList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitValuesList(HqlParser.ValuesListContext ctx);
	/**
	 * Visit a parse tree produced by the {@code values}
	 * labeled alternative in {@link HqlParser#queryqueryfromRootfromRootfromRootjoinTargetjoinTargetjoinTargetexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionfunctionfunctionfunctionfunctionfunctionfunctionfunctionfunctioncollectionAggregateFunctioncollectionAggregateFunctionpredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitValues(HqlParser.ValuesContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#conflictClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConflictClause(HqlParser.ConflictClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#conflictTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConflictTarget(HqlParser.ConflictTargetContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#conflictAction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConflictAction(HqlParser.ConflictActionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiation}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiation(HqlParser.InstantiationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#groupedItem}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupedItem(HqlParser.GroupedItemContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#sortedItem}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSortedItem(HqlParser.SortedItemContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#sortExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSortExpression(HqlParser.SortExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#sortDirection}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSortDirection(HqlParser.SortDirectionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#nullsPrecedence}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNullsPrecedence(HqlParser.NullsPrecedenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#limitClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLimitClause(HqlParser.LimitClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offsetClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffsetClause(HqlParser.OffsetClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#fetchClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFetchClause(HqlParser.FetchClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#subquery}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubquery(HqlParser.SubqueryContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectClause(HqlParser.SelectClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectionList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectionList(HqlParser.SelectionListContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selection}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelection(HqlParser.SelectionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectExpression(HqlParser.SelectExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#mapEntrySelection}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jpaSelectObjectSyntax}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#whereClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWhereClause(HqlParser.WhereClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#joinType}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinType(HqlParser.JoinTypeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#crossJoin}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCrossJoin(HqlParser.CrossJoinContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#joinRestriction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinRestriction(HqlParser.JoinRestrictionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jpaCollectionJoin}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#groupByClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupByClause(HqlParser.GroupByClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#orderByClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrderByClause(HqlParser.OrderByClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#havingClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitHavingClause(HqlParser.HavingClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#setOperator}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSetOperator(HqlParser.SetOperatorContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLiteral(HqlParser.LiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#booleanLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBooleanLiteral(HqlParser.BooleanLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#numericLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNumericLiteral(HqlParser.NumericLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dateTimeLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#localDateTimeLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLocalDateTimeLiteral(HqlParser.LocalDateTimeLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#zonedDateTimeLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitZonedDateTimeLiteral(HqlParser.ZonedDateTimeLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offsetDateTimeLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffsetDateTimeLiteral(HqlParser.OffsetDateTimeLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dateLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDateLiteral(HqlParser.DateLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#timeLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTimeLiteral(HqlParser.TimeLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dateTime}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDateTime(HqlParser.DateTimeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#localDateTime}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLocalDateTime(HqlParser.LocalDateTimeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#zonedDateTime}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitZonedDateTime(HqlParser.ZonedDateTimeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offsetDateTime}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffsetDateTime(HqlParser.OffsetDateTimeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offsetDateTimeWithMinutes}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffsetDateTimeWithMinutes(HqlParser.OffsetDateTimeWithMinutesContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jdbcTimestampLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jdbcDateLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jdbcTimeLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#genericTemporalLiteralText}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGenericTemporalLiteralText(HqlParser.GenericTemporalLiteralTextContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#arrayLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitArrayLiteral(HqlParser.ArrayLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#generalizedLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#generalizedLiteralType}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneralizedLiteralType(HqlParser.GeneralizedLiteralTypeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#generalizedLiteralText}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneralizedLiteralText(HqlParser.GeneralizedLiteralTextContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#date}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDate(HqlParser.DateContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#time}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTime(HqlParser.TimeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offset}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffset(HqlParser.OffsetContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offsetWithMinutes}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffsetWithMinutes(HqlParser.OffsetWithMinutesContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#year}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitYear(HqlParser.YearContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#month}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMonth(HqlParser.MonthContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#day}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDay(HqlParser.DayContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#hour}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitHour(HqlParser.HourContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#minute}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMinute(HqlParser.MinuteContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#second}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSecond(HqlParser.SecondContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#zoneId}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitZoneId(HqlParser.ZoneIdContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#extractField}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExtractField(HqlParser.ExtractFieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#datetimeField}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDatetimeField(HqlParser.DatetimeFieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dayField}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDayField(HqlParser.DayFieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#weekField}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWeekField(HqlParser.WeekFieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#timeZoneField}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dateOrTimeField}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDateOrTimeField(HqlParser.DateOrTimeFieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#binaryLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#temporalLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTemporalLiteral(HqlParser.TemporalLiteralContext ctx);
	/**
	 * Visit a parse tree produced by the {@code AdditionExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAdditionExpression(HqlParser.AdditionExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code FromDurationExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code PlainPrimaryExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPlainPrimaryExpression(HqlParser.PlainPrimaryExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code TupleExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTupleExpression(HqlParser.TupleExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GroupedExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupedExpression(HqlParser.GroupedExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SignedNumericLiteral}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSignedNumericLiteral(HqlParser.SignedNumericLiteralContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ToDurationExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SubqueryExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code DayOfMonthExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDayOfMonthExpression(HqlParser.DayOfMonthExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code DayOfWeekExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDayOfWeekExpression(HqlParser.DayOfWeekExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code WeekOfYearExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWeekOfYearExpression(HqlParser.WeekOfYearExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code HqlConcatenationExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitHqlConcatenationExpression(HqlParser.HqlConcatenationExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code MultiplicationExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SignedExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSignedExpression(HqlParser.SignedExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CaseExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseExpression(HqlParser.CaseExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code LiteralExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLiteralExpression(HqlParser.LiteralExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ParameterExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameterExpression(HqlParser.ParameterExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EntityTypeExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EntityIdExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityIdExpression(HqlParser.EntityIdExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EntityVersionExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityVersionExpression(HqlParser.EntityVersionExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EntityNaturalIdExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityNaturalIdExpression(HqlParser.EntityNaturalIdExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SyntacticPathExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSyntacticPathExpression(HqlParser.SyntacticPathExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code FunctionExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctionExpression(HqlParser.FunctionExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GeneralPathExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#path}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPath(HqlParser.PathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#generalPathFragment}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#indexedPathAccessFragment}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#simplePath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimplePath(HqlParser.SimplePathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#simplePathElement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimplePathElement(HqlParser.SimplePathElementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#pathContinuation}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPathContinuation(HqlParser.PathContinuationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityTypeReference}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityTypeReference(HqlParser.EntityTypeReferenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityIdReference}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityVersionReference}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityNaturalIdReference}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#syntacticDomainPath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#slicedPathAccessFragment}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSlicedPathAccessFragment(HqlParser.SlicedPathAccessFragmentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#treatedNavigablePath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#collectionValueNavigablePath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionValueNavigablePath(HqlParser.CollectionValueNavigablePathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#mapKeyNavigablePath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#toOneFkReference}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitToOneFkReference(HqlParser.ToOneFkReferenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#caseList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseList(HqlParser.CaseListContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#simpleCaseExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimpleCaseExpression(HqlParser.SimpleCaseExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#searchedCaseExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSearchedCaseExpression(HqlParser.SearchedCaseExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#caseWhenExpressionClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseWhenExpressionClause(HqlParser.CaseWhenExpressionClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#caseWhenPredicateClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseWhenPredicateClause(HqlParser.CaseWhenPredicateClauseContext ctx);
	/**
	 * Visit a parse tree produced by the {@code StandardFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStandardFunctionInvocation(HqlParser.StandardFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code AggregateFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAggregateFunctionInvocation(HqlParser.AggregateFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CollectionSizeFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionSizeFunctionInvocation(HqlParser.CollectionSizeFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CollectionAggregateFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionAggregateFunctionInvocation(HqlParser.CollectionAggregateFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CollectionFunctionMisuseInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionFunctionMisuseInvocation(HqlParser.CollectionFunctionMisuseInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code JpaNonstandardFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJpaNonstandardFunctionInvocation(HqlParser.JpaNonstandardFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ColumnFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitColumnFunctionInvocation(HqlParser.ColumnFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GenericFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGenericFunctionInvocation(HqlParser.GenericFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#setReturningFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSetReturningFunction(HqlParser.SetReturningFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#simpleSetReturningFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimpleSetReturningFunction(HqlParser.SimpleSetReturningFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#standardFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStandardFunction(HqlParser.StandardFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#castFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCastFunction(HqlParser.CastFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#castTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCastTarget(HqlParser.CastTargetContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#castTargetType}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCastTargetType(HqlParser.CastTargetTypeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#substringFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubstringFunction(HqlParser.SubstringFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#substringFunctionStartArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubstringFunctionStartArgument(HqlParser.SubstringFunctionStartArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#substringFunctionLengthArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubstringFunctionLengthArgument(HqlParser.SubstringFunctionLengthArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#trimFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTrimFunction(HqlParser.TrimFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#trimSpecification}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTrimSpecification(HqlParser.TrimSpecificationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#trimCharacter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTrimCharacter(HqlParser.TrimCharacterContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#padFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPadFunction(HqlParser.PadFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#padSpecification}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPadSpecification(HqlParser.PadSpecificationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#padCharacter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPadCharacter(HqlParser.PadCharacterContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#padLength}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPadLength(HqlParser.PadLengthContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#positionFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPositionFunction(HqlParser.PositionFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#positionFunctionPatternArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPositionFunctionPatternArgument(HqlParser.PositionFunctionPatternArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#positionFunctionStringArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPositionFunctionStringArgument(HqlParser.PositionFunctionStringArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#overlayFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOverlayFunction(HqlParser.OverlayFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#overlayFunctionStringArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOverlayFunctionStringArgument(HqlParser.OverlayFunctionStringArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#overlayFunctionReplacementArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOverlayFunctionReplacementArgument(HqlParser.OverlayFunctionReplacementArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#overlayFunctionStartArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOverlayFunctionStartArgument(HqlParser.OverlayFunctionStartArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#overlayFunctionLengthArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOverlayFunctionLengthArgument(HqlParser.OverlayFunctionLengthArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#currentDateFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#currentTimeFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#currentTimestampFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantFunction(HqlParser.InstantFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#localDateTimeFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offsetDateTimeFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#localDateFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#localTimeFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#formatFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFormatFunction(HqlParser.FormatFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#collation}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollation(HqlParser.CollationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#collateFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollateFunction(HqlParser.CollateFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#cube}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCube(HqlParser.CubeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#rollup}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRollup(HqlParser.RollupContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#format}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFormat(HqlParser.FormatContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#extractFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExtractFunction(HqlParser.ExtractFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#truncFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTruncFunction(HqlParser.TruncFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jpaNonstandardFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJpaNonstandardFunction(HqlParser.JpaNonstandardFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jpaNonstandardFunctionName}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJpaNonstandardFunctionName(HqlParser.JpaNonstandardFunctionNameContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#columnFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitColumnFunction(HqlParser.ColumnFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#genericFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGenericFunction(HqlParser.GenericFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#genericFunctionName}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGenericFunctionName(HqlParser.GenericFunctionNameContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#genericFunctionArguments}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGenericFunctionArguments(HqlParser.GenericFunctionArgumentsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#collectionSizeFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ElementAggregateFunction}
	 * labeled alternative in {@link HqlParser#collectionAggregateFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitElementAggregateFunction(HqlParser.ElementAggregateFunctionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code IndexAggregateFunction}
	 * labeled alternative in {@link HqlParser#collectionAggregateFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIndexAggregateFunction(HqlParser.IndexAggregateFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#collectionFunctionMisuse}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionFunctionMisuse(HqlParser.CollectionFunctionMisuseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#aggregateFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAggregateFunction(HqlParser.AggregateFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#everyFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEveryFunction(HqlParser.EveryFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#anyFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAnyFunction(HqlParser.AnyFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#everyAllQuantifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEveryAllQuantifier(HqlParser.EveryAllQuantifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#anySomeQuantifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAnySomeQuantifier(HqlParser.AnySomeQuantifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#listaggFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitListaggFunction(HqlParser.ListaggFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#onOverflowClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOnOverflowClause(HqlParser.OnOverflowClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#withinGroupClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWithinGroupClause(HqlParser.WithinGroupClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#filterClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFilterClause(HqlParser.FilterClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#nullsClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNullsClause(HqlParser.NullsClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#nthSideClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNthSideClause(HqlParser.NthSideClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#overClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOverClause(HqlParser.OverClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#partitionClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPartitionClause(HqlParser.PartitionClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#frameClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFrameClause(HqlParser.FrameClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#frameStart}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFrameStart(HqlParser.FrameStartContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#frameEnd}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFrameEnd(HqlParser.FrameEndContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#frameExclusion}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFrameExclusion(HqlParser.FrameExclusionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code IsDistinctFromPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIsDistinctFromPredicate(HqlParser.IsDistinctFromPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ContainsPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitContainsPredicate(HqlParser.ContainsPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code IsBooleanPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIsBooleanPredicate(HqlParser.IsBooleanPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code BetweenPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code RelationalPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRelationalPredicate(HqlParser.RelationalPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExistsPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExistsPredicate(HqlParser.ExistsPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code AndPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAndPredicate(HqlParser.AndPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GroupedPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code LikePredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLikePredicate(HqlParser.LikePredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code InPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInPredicate(HqlParser.InPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code NotPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNotPredicate(HqlParser.NotPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExpressionPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionPredicate(HqlParser.ExpressionPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code OrPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrPredicate(HqlParser.OrPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code MemberOfPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#expressionOrPredicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionOrPredicate(HqlParser.ExpressionOrPredicateContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#collectionQuantifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionQuantifier(HqlParser.CollectionQuantifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#elementsValuesQuantifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitElementsValuesQuantifier(HqlParser.ElementsValuesQuantifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#elementValueQuantifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitElementValueQuantifier(HqlParser.ElementValueQuantifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#indexKeyQuantifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIndexKeyQuantifier(HqlParser.IndexKeyQuantifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#indicesKeysQuantifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIndicesKeysQuantifier(HqlParser.IndicesKeysQuantifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#relationalExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRelationalExpression(HqlParser.RelationalExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#betweenExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBetweenExpression(HqlParser.BetweenExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#stringPatternMatching}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStringPatternMatching(HqlParser.StringPatternMatchingContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#inExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInExpression(HqlParser.InExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#inList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInList(HqlParser.InListContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#existsExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExistsExpression(HqlParser.ExistsExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiationTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiationTarget(HqlParser.InstantiationTargetContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiationArguments}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiationArguments(HqlParser.InstantiationArgumentsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiationArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#parameterOrIntegerLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#parameterOrNumberLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitVariable(HqlParser.VariableContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#parameter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameter(HqlParser.ParameterContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityName}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityName(HqlParser.EntityNameContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#nakedIdentifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNakedIdentifier(HqlParser.NakedIdentifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#identifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIdentifier(HqlParser.IdentifierContext ctx);
}