/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.DeclaredQueries;
import org.springframework.data.jpa.repository.query.QueryProvider;

public interface DeclaredQuery
extends QueryProvider {
    public static DeclaredQuery jpqlQuery(String jpql) {
        return new DeclaredQueries.JpqlQuery(jpql);
    }

    public static DeclaredQuery nativeQuery(String sql) {
        return new DeclaredQueries.NativeQuery(sql);
    }

    public boolean isNative();

    default public boolean isJpql() {
        return !this.isNative();
    }

    default public DeclaredQuery rewrite(String newQueryString) {
        if (this.getQueryString().equals(newQueryString)) {
            return this;
        }
        return new DeclaredQueries.RewrittenQuery(this, newQueryString);
    }
}

