/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;

abstract class FluentQuerySupport<S, R> {
    protected final ReturnedType returnedType;
    protected final Class<R> resultType;
    protected final Sort sort;
    protected final int limit;
    protected final Set<String> properties;
    protected final Class<S> entityType;
    protected final ProjectionFactory projectionFactory;

    FluentQuerySupport(Class<R> resultType, Sort sort, int limit, @Nullable Collection<String> properties, Class<S> entityType, ProjectionFactory projectionFactory) {
        this.returnedType = ReturnedType.of(resultType, entityType, (ProjectionFactory)projectionFactory);
        this.resultType = resultType;
        this.sort = sort;
        this.limit = limit;
        this.properties = properties != null ? new HashSet<String>(properties) : Collections.emptySet();
        this.entityType = entityType;
        this.projectionFactory = projectionFactory;
    }

    final Collection<String> mergeProperties(Collection<String> additionalProperties) {
        HashSet<String> newProperties = new HashSet<String>();
        newProperties.addAll(this.properties);
        newProperties.addAll(additionalProperties);
        return Collections.unmodifiableCollection(newProperties);
    }

    final Function<Object, R> getConversionFunction(Class<S> inputType, Class<R> targetType) {
        if (targetType.isAssignableFrom(inputType)) {
            return Function.identity();
        }
        if (this.returnedType.isProjecting()) {
            AbstractJpaQuery.TupleConverter tupleConverter = new AbstractJpaQuery.TupleConverter(this.returnedType);
            if (this.resultType.isInterface()) {
                return o -> this.projectionFactory.createProjection(targetType, tupleConverter.convert(o));
            }
        }
        return o -> DefaultConversionService.getSharedInstance().convert(o, targetType);
    }

    Pageable withSort(Pageable pageable, Sort sort) {
        if (pageable instanceof PageRequest) {
            PageRequest pr = (PageRequest)pageable;
            if (pageable.getSort() != sort) {
                return pr.withSort(sort);
            }
        }
        return pageable;
    }

    static interface ScrollQueryFactory<Q> {
        public Q createQuery(FluentQuerySupport<?, ?> var1, ScrollPosition var2);
    }
}

