/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.util.CompositeIterator;

abstract class QueryRenderer
implements QueryTokenStream {
    QueryRenderer() {
    }

    static QueryRenderer from(QueryToken token) {
        return QueryRenderer.from(Collections.singletonList(token));
    }

    static QueryRenderer from(Collection<? extends QueryToken> tokens) {
        ArrayList<QueryToken> tokensToUse = new ArrayList<QueryToken>(Math.max(tokens.size(), 32));
        tokensToUse.addAll(tokens);
        return new TokenRenderer(tokensToUse);
    }

    static QueryRenderer from(QueryTokenStream tokens) {
        if (tokens instanceof QueryRendererBuilder) {
            QueryRendererBuilder builder = (QueryRendererBuilder)tokens;
            tokens = builder.current;
        }
        if (tokens instanceof QueryRenderer) {
            QueryRenderer renderer = (QueryRenderer)tokens;
            return renderer;
        }
        return new QueryStreamRenderer(tokens);
    }

    public static QueryRenderer empty() {
        return EmptyQueryRenderer.INSTANCE;
    }

    static QueryRendererBuilder builder() {
        return new QueryRendererBuilder();
    }

    abstract String render();

    static String render(Iterable<QueryToken> tokenStream) {
        if (tokenStream instanceof QueryRendererBuilder) {
            QueryRendererBuilder qrb = (QueryRendererBuilder)tokenStream;
            tokenStream = qrb.current;
        }
        if (tokenStream instanceof QueryRenderer) {
            QueryRenderer qr = (QueryRenderer)tokenStream;
            return qr.render();
        }
        StringBuilder results = null;
        boolean previousExpression = false;
        Iterator iterator = tokenStream.iterator();
        while (iterator.hasNext()) {
            QueryToken token = (QueryToken)iterator.next();
            if (results == null) {
                if (iterator.hasNext()) {
                    results = new StringBuilder();
                } else {
                    return token.value();
                }
            }
            if (previousExpression && !results.isEmpty() && results.charAt(results.length() - 1) != ' ') {
                results.append(' ');
            }
            previousExpression = token.isExpression();
            results.append(token.value());
        }
        return results.toString();
    }

    QueryRenderer append(QueryTokenStream tokens) {
        if (tokens instanceof QueryRendererBuilder) {
            QueryRendererBuilder builder = (QueryRendererBuilder)tokens;
            tokens = builder.current;
        }
        if (tokens instanceof QueryRenderer) {
            QueryRenderer qr = (QueryRenderer)tokens;
            if (this.isEmpty()) {
                return qr;
            }
            return CompositeRenderer.combine(this, qr);
        }
        if (this.isEmpty()) {
            return QueryRenderer.from(tokens);
        }
        return CompositeRenderer.combine(this, QueryRenderer.from(tokens));
    }

    public String toString() {
        return this.render();
    }

    public static QueryRenderer expression(QueryTokenStream tokenStream) {
        if (tokenStream instanceof QueryRendererBuilder) {
            QueryRendererBuilder builder = (QueryRendererBuilder)tokenStream;
            tokenStream = builder.current;
        }
        if (tokenStream.isEmpty()) {
            return EmptyQueryRenderer.INSTANCE;
        }
        if (tokenStream.isExpression()) {
            return (QueryRenderer)tokenStream;
        }
        return new ExpressionRenderer((QueryRenderer)tokenStream);
    }

    public static QueryRenderer inline(QueryTokenStream tokenStream) {
        if (tokenStream instanceof QueryRendererBuilder) {
            QueryRendererBuilder builder = (QueryRendererBuilder)tokenStream;
            tokenStream = builder.current;
        }
        if (tokenStream.isEmpty()) {
            return EmptyQueryRenderer.INSTANCE;
        }
        if (!tokenStream.isExpression()) {
            return (QueryRenderer)tokenStream;
        }
        return new InlineRenderer((QueryRenderer)tokenStream);
    }

    static class CompositeRenderer
    extends QueryRenderer {
        private final List<QueryRenderer> nested;

        static CompositeRenderer combine(QueryRenderer root, QueryRenderer nested) {
            ArrayList<QueryRenderer> queryRenderers = new ArrayList<QueryRenderer>(32);
            queryRenderers.add(root);
            queryRenderers.add(nested);
            return new CompositeRenderer(queryRenderers);
        }

        private CompositeRenderer(List<QueryRenderer> nested) {
            this.nested = nested;
        }

        @Override
        String render() {
            StringBuilder builder = new StringBuilder(64);
            String lastAppended = null;
            boolean lastExpression = false;
            for (QueryRenderer queryRenderer : this.nested) {
                if (lastAppended != null && (lastExpression || queryRenderer.isExpression()) && !builder.isEmpty() && !lastAppended.endsWith(" ")) {
                    builder.append(' ');
                }
                lastAppended = queryRenderer.render();
                builder.append(lastAppended);
                lastExpression = queryRenderer.isExpression();
            }
            return builder.toString();
        }

        @Override
        QueryRenderer append(QueryTokenStream tokens) {
            if (tokens instanceof QueryRendererBuilder) {
                QueryRendererBuilder builder = (QueryRendererBuilder)tokens;
                tokens = builder.current;
            }
            if (tokens instanceof QueryRenderer) {
                QueryRenderer qr = (QueryRenderer)tokens;
                if (this.isEmpty()) {
                    return this;
                }
                if (qr.isEmpty()) {
                    return qr;
                }
                if (tokens instanceof CompositeRenderer) {
                    CompositeRenderer cr = (CompositeRenderer)tokens;
                    this.nested.addAll(cr.nested);
                    return this;
                }
            }
            return super.append(tokens);
        }

        @Override
        public QueryToken getLast() {
            int i = this.nested.size() - 1;
            while (i > -1) {
                QueryRenderer renderer = this.nested.get(i);
                if (!renderer.isEmpty()) {
                    return renderer.getLast();
                }
                --i;
            }
            return null;
        }

        public Iterator<QueryToken> iterator() {
            CompositeIterator iterator = new CompositeIterator();
            for (QueryTokenStream queryTokenStream : this.nested) {
                iterator.add(queryTokenStream.iterator());
            }
            return iterator;
        }

        @Override
        public boolean isEmpty() {
            for (QueryRenderer renderer : this.nested) {
                if (renderer.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public int size() {
            int size = 0;
            for (QueryTokenStream queryTokenStream : this.nested) {
                size += queryTokenStream.size();
            }
            return size;
        }

        @Override
        public boolean isExpression() {
            return !this.nested.isEmpty() && this.nested.get(this.nested.size() - 1).isExpression();
        }
    }

    private static class EmptyQueryRenderer
    extends QueryRenderer {
        public static final QueryRenderer INSTANCE = new EmptyQueryRenderer();

        private EmptyQueryRenderer() {
        }

        @Override
        String render() {
            return "";
        }

        @Override
        QueryRenderer append(QueryTokenStream tokens) {
            if (tokens.isEmpty()) {
                return this;
            }
            if (tokens instanceof QueryRenderer) {
                QueryRenderer qr = (QueryRenderer)tokens;
                return qr;
            }
            return QueryRenderer.from(tokens);
        }

        public List<QueryToken> toList() {
            return Collections.emptyList();
        }

        public Stream<QueryToken> stream() {
            return Stream.empty();
        }

        public Iterator<QueryToken> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isExpression() {
            return false;
        }
    }

    private static class ExpressionRenderer
    extends QueryRenderer {
        private final QueryRenderer delegate;

        private ExpressionRenderer(QueryRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        String render() {
            return this.delegate.render();
        }

        public Stream<QueryToken> stream() {
            return this.delegate.stream();
        }

        public List<QueryToken> toList() {
            return this.delegate.toList();
        }

        public Iterator<QueryToken> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public QueryToken getFirst() {
            return this.delegate.getFirst();
        }

        @Override
        public QueryToken getLast() {
            return this.delegate.getLast();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isExpression() {
            return true;
        }
    }

    private static class InlineRenderer
    extends QueryRenderer {
        private final QueryRenderer delegate;

        private InlineRenderer(QueryRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        String render() {
            return this.delegate.render();
        }

        public Stream<QueryToken> stream() {
            return this.delegate.stream();
        }

        public List<QueryToken> toList() {
            return this.delegate.toList();
        }

        public Iterator<QueryToken> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public QueryToken getFirst() {
            return this.delegate.getFirst();
        }

        @Override
        public QueryToken getLast() {
            return this.delegate.getLast();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isExpression() {
            return false;
        }
    }

    static class QueryRendererBuilder
    implements QueryTokenStream {
        protected QueryRenderer current = QueryRenderer.empty();

        QueryRendererBuilder() {
        }

        public static <T> QueryRendererBuilder concat(Collection<T> elements, Function<T, QueryRendererBuilder> visitor, QueryToken separator) {
            return QueryRendererBuilder.concat(elements, visitor, QueryRendererBuilder::toInline, separator);
        }

        public static <T> QueryRendererBuilder concatExpressions(Collection<T> elements, Function<T, QueryRendererBuilder> visitor, QueryToken separator) {
            return QueryRendererBuilder.concat(elements, visitor, QueryRendererBuilder::toExpression, separator);
        }

        public static <T> QueryRendererBuilder concat(Collection<T> elements, Function<T, QueryRendererBuilder> visitor, Function<QueryRendererBuilder, QueryRenderer> postProcess, QueryToken separator) {
            QueryRendererBuilder builder = new QueryRendererBuilder();
            for (T element : elements) {
                if (!builder.isEmpty()) {
                    builder.append(separator);
                }
                builder.append(postProcess.apply(visitor.apply(element)));
            }
            return builder;
        }

        public static QueryRendererBuilder from(QueryToken token) {
            return new QueryRendererBuilder().append(token);
        }

        QueryRendererBuilder append(QueryToken token) {
            return this.append(QueryRenderer.from(token));
        }

        QueryRendererBuilder append(List<? extends QueryToken> tokens) {
            return this.append(QueryRenderer.from(tokens));
        }

        QueryRendererBuilder appendExpression(QueryRendererBuilder builder) {
            return this.appendExpression(builder.current);
        }

        QueryRendererBuilder append(QueryTokenStream stream) {
            if (stream.isEmpty()) {
                return this;
            }
            this.current = this.current.append(stream);
            return this;
        }

        QueryRendererBuilder appendInline(QueryTokenStream stream) {
            if (stream.isEmpty()) {
                return this;
            }
            this.current = this.current.append(QueryRenderer.inline(stream));
            return this;
        }

        QueryRendererBuilder appendExpression(QueryTokenStream tokens) {
            if (tokens.isEmpty()) {
                return this;
            }
            this.current = this.current.append(QueryRenderer.expression(tokens));
            return this;
        }

        public List<QueryToken> toList() {
            return this.current.toList();
        }

        public Stream<QueryToken> stream() {
            return this.current.stream();
        }

        @Override
        public QueryToken getFirst() {
            return this.current.getFirst();
        }

        @Override
        public QueryToken getLast() {
            return this.current.getLast();
        }

        @Override
        public boolean isExpression() {
            return this.current.isExpression();
        }

        @Override
        public boolean isEmpty() {
            return this.current.isEmpty();
        }

        @Override
        public int size() {
            return this.current.size();
        }

        public Iterator<QueryToken> iterator() {
            return this.current.iterator();
        }

        public String toString() {
            return this.current.render();
        }

        public QueryRenderer build() {
            return this.current;
        }

        QueryRenderer toExpression() {
            if (this.current instanceof ExpressionRenderer) {
                return this.current;
            }
            return QueryRenderer.expression(this.current);
        }

        public QueryRenderer toInline() {
            return new InlineRenderer(this.current);
        }
    }

    static class QueryStreamRenderer
    extends QueryRenderer {
        private final QueryTokenStream tokens;

        public QueryStreamRenderer(QueryTokenStream tokens) {
            this.tokens = tokens;
        }

        @Override
        String render() {
            return QueryStreamRenderer.render((Iterable<QueryToken>)((Object)this.tokens));
        }

        public Iterator<QueryToken> iterator() {
            return this.tokens.iterator();
        }

        @Override
        public QueryToken getFirst() {
            return this.tokens.getFirst();
        }

        @Override
        public QueryToken getLast() {
            return this.tokens.getLast();
        }

        @Override
        public int size() {
            return this.tokens.size();
        }

        @Override
        public boolean isEmpty() {
            return this.tokens.isEmpty();
        }

        @Override
        public boolean isExpression() {
            return !this.tokens.isEmpty() && this.tokens.getLast().isExpression();
        }
    }

    static class TokenRenderer
    extends QueryRenderer {
        private final List<QueryToken> tokens;

        TokenRenderer(List<QueryToken> tokens) {
            this.tokens = tokens;
        }

        @Override
        String render() {
            return TokenRenderer.render(this.tokens);
        }

        @Override
        QueryRenderer append(QueryTokenStream tokens) {
            if (tokens instanceof TokenRenderer) {
                TokenRenderer tr = (TokenRenderer)tokens;
                this.tokens.addAll(tr.tokens);
                return this;
            }
            return super.append(tokens);
        }

        public Stream<QueryToken> stream() {
            return this.tokens.stream();
        }

        public Iterator<QueryToken> iterator() {
            return this.tokens.iterator();
        }

        public List<QueryToken> toList() {
            return this.tokens;
        }

        @Override
        public QueryToken getFirst() {
            return this.tokens.isEmpty() ? null : this.tokens.get(0);
        }

        @Override
        public QueryToken getLast() {
            return this.tokens.isEmpty() ? null : this.tokens.get(this.tokens.size() - 1);
        }

        @Override
        public int size() {
            return this.tokens.size();
        }

        @Override
        public boolean isEmpty() {
            return this.tokens.isEmpty();
        }

        @Override
        public boolean isExpression() {
            return !this.tokens.isEmpty() && this.getLast().isExpression();
        }

        static String render(Object tokens) {
            if (tokens instanceof Collection) {
                Collection tpr = (Collection)tokens;
                return TokenRenderer.render(tpr);
            }
            if (tokens instanceof QueryRendererBuilder) {
                QueryRendererBuilder qrb = (QueryRendererBuilder)tokens;
                return qrb.build().render();
            }
            if (tokens instanceof QueryRenderer) {
                QueryRenderer qr = (QueryRenderer)tokens;
                return qr.render();
            }
            throw new IllegalArgumentException("Unknown token type %s".formatted(tokens));
        }
    }
}

