// Generated from org/springframework/data/jpa/repository/query/Hql.g4 by ANTLR 4.10.1
package org.springframework.data.jpa.repository.query;

/**
 * HQL per https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html#query-language
 *
 * This is a mixture of Hibernate's BNF and missing bits of grammar. There are gaps and inconsistencies in the
 * BNF itself, explained by other fragments of their spec. Additionally, alternate labels are used to provide easier
 * management of complex rules in the generated Visitor. Finally, there are labels applied to rule elements (op=('+'|'-')
 * to simplify the processing.
 *
 * @author Greg Turnquist
 * @since 3.1
 */

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

/**
 * This interface defines a complete generic visitor for a parse tree produced
 * by {@link HqlParser}.
 *
 * @param <T> The return type of the visit operation. Use {@link Void} for
 * operations with no return type.
 */
interface HqlVisitor<T> extends ParseTreeVisitor<T> {
	/**
	 * Visit a parse tree produced by {@link HqlParser#start}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStart(HqlParser.StartContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#ql_statement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQl_statement(HqlParser.Ql_statementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectStatement(HqlParser.SelectStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#queryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQueryExpression(HqlParser.QueryExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#orderedQuery}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrderedQuery(HqlParser.OrderedQueryContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SelectQuery}
	 * labeled alternative in {@link HqlParser#query}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectQuery(HqlParser.SelectQueryContext ctx);
	/**
	 * Visit a parse tree produced by the {@code FromQuery}
	 * labeled alternative in {@link HqlParser#query}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFromQuery(HqlParser.FromQueryContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#queryOrder}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQueryOrder(HqlParser.QueryOrderContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#fromClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFromClause(HqlParser.FromClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityWithJoins}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityWithJoins(HqlParser.EntityWithJoinsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#joinSpecifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinSpecifier(HqlParser.JoinSpecifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#fromRoot}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFromRoot(HqlParser.FromRootContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#join}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin(HqlParser.JoinContext ctx);
	/**
	 * Visit a parse tree produced by the {@code JoinPath}
	 * labeled alternative in {@link HqlParser#joinTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinPath(HqlParser.JoinPathContext ctx);
	/**
	 * Visit a parse tree produced by the {@code JoinSubquery}
	 * labeled alternative in {@link HqlParser#joinTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinSubquery(HqlParser.JoinSubqueryContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#updateStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitUpdateStatement(HqlParser.UpdateStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#targetEntity}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTargetEntity(HqlParser.TargetEntityContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#setClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSetClause(HqlParser.SetClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#assignment}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAssignment(HqlParser.AssignmentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#deleteStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDeleteStatement(HqlParser.DeleteStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#insertStatement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInsertStatement(HqlParser.InsertStatementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#targetFields}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTargetFields(HqlParser.TargetFieldsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#valuesList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitValuesList(HqlParser.ValuesListContext ctx);
	/**
	 * Visit a parse tree produced by the {@code values}
	 * labeled alternative in {@link HqlParser#queryqueryjoinTargetjoinTargetexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionexpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionprimaryExpressionfunctionfunctionfunctionfunctionfunctionfunctionfunctionfunctionframeStartframeStartframeStartframeStartframeExclusionframeExclusionframeExclusionframeExclusionframeEndframeEndframeEndframeEndpredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicatepredicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitValues(HqlParser.ValuesContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#projectedItem}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitProjectedItem(HqlParser.ProjectedItemContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiation}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiation(HqlParser.InstantiationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#alias}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAlias(HqlParser.AliasContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#groupedItem}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupedItem(HqlParser.GroupedItemContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#sortedItem}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSortedItem(HqlParser.SortedItemContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#sortExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSortExpression(HqlParser.SortExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#sortDirection}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSortDirection(HqlParser.SortDirectionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#nullsPrecedence}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNullsPrecedence(HqlParser.NullsPrecedenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#limitClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLimitClause(HqlParser.LimitClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#offsetClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOffsetClause(HqlParser.OffsetClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#fetchClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFetchClause(HqlParser.FetchClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#subquery}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubquery(HqlParser.SubqueryContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectClause(HqlParser.SelectClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectionList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectionList(HqlParser.SelectionListContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selection}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelection(HqlParser.SelectionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#selectExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelectExpression(HqlParser.SelectExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#mapEntrySelection}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jpaSelectObjectSyntax}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#whereClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWhereClause(HqlParser.WhereClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#joinType}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinType(HqlParser.JoinTypeContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#crossJoin}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCrossJoin(HqlParser.CrossJoinContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#joinRestriction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoinRestriction(HqlParser.JoinRestrictionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#jpaCollectionJoin}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#groupByClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupByClause(HqlParser.GroupByClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#orderByClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrderByClause(HqlParser.OrderByClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#havingClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitHavingClause(HqlParser.HavingClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#setOperator}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSetOperator(HqlParser.SetOperatorContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLiteral(HqlParser.LiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#booleanLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBooleanLiteral(HqlParser.BooleanLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#stringLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStringLiteral(HqlParser.StringLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#numericLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNumericLiteral(HqlParser.NumericLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dateTimeLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx);
	/**
	 * Visit a parse tree produced by the {@code AdditionExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAdditionExpression(HqlParser.AdditionExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code PlainPrimaryExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPlainPrimaryExpression(HqlParser.PlainPrimaryExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code TupleExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTupleExpression(HqlParser.TupleExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code HqlConcatenationExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitHqlConcatenationExpression(HqlParser.HqlConcatenationExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GroupedExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupedExpression(HqlParser.GroupedExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SignedNumericLiteral}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSignedNumericLiteral(HqlParser.SignedNumericLiteralContext ctx);
	/**
	 * Visit a parse tree produced by the {@code MultiplicationExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SubqueryExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code SignedExpression}
	 * labeled alternative in {@link HqlParser#expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSignedExpression(HqlParser.SignedExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CaseExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseExpression(HqlParser.CaseExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code LiteralExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLiteralExpression(HqlParser.LiteralExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ParameterExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameterExpression(HqlParser.ParameterExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code FunctionExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctionExpression(HqlParser.FunctionExpressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GeneralPathExpression}
	 * labeled alternative in {@link HqlParser#primaryExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#identificationVariable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIdentificationVariable(HqlParser.IdentificationVariableContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#path}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPath(HqlParser.PathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#generalPathFragment}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#indexedPathAccessFragment}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#simplePath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimplePath(HqlParser.SimplePathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#simplePathElement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimplePathElement(HqlParser.SimplePathElementContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#caseList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseList(HqlParser.CaseListContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#simpleCaseExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimpleCaseExpression(HqlParser.SimpleCaseExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#searchedCaseExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSearchedCaseExpression(HqlParser.SearchedCaseExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#caseWhenExpressionClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseWhenExpressionClause(HqlParser.CaseWhenExpressionClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#caseWhenPredicateClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCaseWhenPredicateClause(HqlParser.CaseWhenPredicateClauseContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GenericFunction}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGenericFunction(HqlParser.GenericFunctionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code FunctionWithSubquery}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctionWithSubquery(HqlParser.FunctionWithSubqueryContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CastFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCastFunctionInvocation(HqlParser.CastFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExtractFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExtractFunctionInvocation(HqlParser.ExtractFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code TrimFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTrimFunctionInvocation(HqlParser.TrimFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EveryFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEveryFunctionInvocation(HqlParser.EveryFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code AnyFunctionInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAnyFunctionInvocation(HqlParser.AnyFunctionInvocationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code TreatedPathInvocation}
	 * labeled alternative in {@link HqlParser#function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTreatedPathInvocation(HqlParser.TreatedPathInvocationContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#functionArguments}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctionArguments(HqlParser.FunctionArgumentsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#filterClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFilterClause(HqlParser.FilterClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#withinGroup}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWithinGroup(HqlParser.WithinGroupContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#overClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOverClause(HqlParser.OverClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#partitionClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPartitionClause(HqlParser.PartitionClauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#frameClause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFrameClause(HqlParser.FrameClauseContext ctx);
	/**
	 * Visit a parse tree produced by the {@code UnboundedPrecedingFrameStart}
	 * labeled alternative in {@link HqlParser#frameStart}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitUnboundedPrecedingFrameStart(HqlParser.UnboundedPrecedingFrameStartContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExpressionPrecedingFrameStart}
	 * labeled alternative in {@link HqlParser#frameStart}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionPrecedingFrameStart(HqlParser.ExpressionPrecedingFrameStartContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CurrentRowFrameStart}
	 * labeled alternative in {@link HqlParser#frameStart}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCurrentRowFrameStart(HqlParser.CurrentRowFrameStartContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExpressionFollowingFrameStart}
	 * labeled alternative in {@link HqlParser#frameStart}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionFollowingFrameStart(HqlParser.ExpressionFollowingFrameStartContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CurrentRowFrameExclusion}
	 * labeled alternative in {@link HqlParser#frameExclusion}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCurrentRowFrameExclusion(HqlParser.CurrentRowFrameExclusionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GroupFrameExclusion}
	 * labeled alternative in {@link HqlParser#frameExclusion}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupFrameExclusion(HqlParser.GroupFrameExclusionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code TiesFrameExclusion}
	 * labeled alternative in {@link HqlParser#frameExclusion}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTiesFrameExclusion(HqlParser.TiesFrameExclusionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code NoOthersFrameExclusion}
	 * labeled alternative in {@link HqlParser#frameExclusion}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNoOthersFrameExclusion(HqlParser.NoOthersFrameExclusionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExpressionPrecedingFrameEnd}
	 * labeled alternative in {@link HqlParser#frameEnd}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionPrecedingFrameEnd(HqlParser.ExpressionPrecedingFrameEndContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CurrentRowFrameEnd}
	 * labeled alternative in {@link HqlParser#frameEnd}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCurrentRowFrameEnd(HqlParser.CurrentRowFrameEndContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExpressionFollowingFrameEnd}
	 * labeled alternative in {@link HqlParser#frameEnd}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionFollowingFrameEnd(HqlParser.ExpressionFollowingFrameEndContext ctx);
	/**
	 * Visit a parse tree produced by the {@code UnboundedFollowingFrameEnd}
	 * labeled alternative in {@link HqlParser#frameEnd}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitUnboundedFollowingFrameEnd(HqlParser.UnboundedFollowingFrameEndContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#castFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCastFunction(HqlParser.CastFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#extractFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExtractFunction(HqlParser.ExtractFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#trimFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTrimFunction(HqlParser.TrimFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dateTimeFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDateTimeFunction(HqlParser.DateTimeFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#everyFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEveryFunction(HqlParser.EveryFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#anyFunction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAnyFunction(HqlParser.AnyFunctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#treatedPath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTreatedPath(HqlParser.TreatedPathContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#pathContinutation}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPathContinutation(HqlParser.PathContinutationContext ctx);
	/**
	 * Visit a parse tree produced by the {@code NullExpressionPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNullExpressionPredicate(HqlParser.NullExpressionPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code BetweenPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code OrPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrPredicate(HqlParser.OrPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code RelationalPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRelationalPredicate(HqlParser.RelationalPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExistsPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExistsPredicate(HqlParser.ExistsPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code CollectionPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionPredicate(HqlParser.CollectionPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code AndPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAndPredicate(HqlParser.AndPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code GroupedPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code LikePredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLikePredicate(HqlParser.LikePredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code InPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInPredicate(HqlParser.InPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code NotPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNotPredicate(HqlParser.NotPredicateContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ExpressionPredicate}
	 * labeled alternative in {@link HqlParser#predicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionPredicate(HqlParser.ExpressionPredicateContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#expressionOrPredicate}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExpressionOrPredicate(HqlParser.ExpressionOrPredicateContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#relationalExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRelationalExpression(HqlParser.RelationalExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#betweenExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBetweenExpression(HqlParser.BetweenExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#dealingWithNullExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDealingWithNullExpression(HqlParser.DealingWithNullExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#stringPatternMatching}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStringPatternMatching(HqlParser.StringPatternMatchingContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#inExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInExpression(HqlParser.InExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#inList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInList(HqlParser.InListContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#existsExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExistsExpression(HqlParser.ExistsExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#collectionExpression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollectionExpression(HqlParser.CollectionExpressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiationTarget}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiationTarget(HqlParser.InstantiationTargetContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiationArguments}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiationArguments(HqlParser.InstantiationArgumentsContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#instantiationArgument}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#parameterOrIntegerLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#parameterOrNumberLiteral}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitVariable(HqlParser.VariableContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#parameter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitParameter(HqlParser.ParameterContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#entityName}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityName(HqlParser.EntityNameContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#identifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIdentifier(HqlParser.IdentifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#character}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCharacter(HqlParser.CharacterContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#functionName}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctionName(HqlParser.FunctionNameContext ctx);
	/**
	 * Visit a parse tree produced by {@link HqlParser#reservedWord}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitReservedWord(HqlParser.ReservedWordContext ctx);
}