/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import javax.persistence.EntityManager;
import javax.persistence.metamodel.Metamodel;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class JpaClassUtils {
    private JpaClassUtils() {
    }

    public static boolean isEntityManagerOfType(EntityManager em, String type) {
        return JpaClassUtils.isOfType(em, type, em.getDelegate().getClass().getClassLoader());
    }

    public static boolean isMetamodelOfType(Metamodel metamodel, String type) {
        return JpaClassUtils.isOfType(metamodel, type, metamodel.getClass().getClassLoader());
    }

    private static boolean isOfType(Object source, String typeName, ClassLoader classLoader) {
        Assert.notNull((Object)source, (String)"Source instance must not be null!");
        Assert.hasText((String)typeName, (String)"Target type name must not be null or empty!");
        try {
            ClassUtils.forName((String)typeName, (ClassLoader)classLoader).cast(source);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

