/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.jpa.domain.support.AuditingBeanFactoryPostProcessor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.JpaMetamodelMappingContextFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class JpaAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static final String BEAN_CONFIGURER_ASPECT_CLASS_NAME = "org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect";

    JpaAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableJpaAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return "jpaAuditingHandler";
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        BeanDefinitionBuilder builder = super.getAuditHandlerBeanDefinitionBuilder(configuration);
        return builder.addConstructorArgReference("jpaMapppingContext");
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        this.registerBeanConfigurerAspectIfNecessary(registry);
        super.registerBeanDefinitions(annotationMetadata, registry);
        this.registerInfrastructureBeanWithId(BeanDefinitionBuilder.rootBeanDefinition(AuditingBeanFactoryPostProcessor.class).getRawBeanDefinition(), AuditingBeanFactoryPostProcessor.class.getName(), registry);
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("jpaMapppingContext")) {
            registry.registerBeanDefinition("jpaMapppingContext", (BeanDefinition)new RootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEntityListener.class);
        builder.addPropertyValue("auditingHandler", (Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), null));
        this.registerInfrastructureBeanWithId(builder.getRawBeanDefinition(), AuditingEntityListener.class.getName(), registry);
    }

    private void registerBeanConfigurerAspectIfNecessary(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(BEAN_CONFIGURER_ASPECT_CLASS_NAME)) {
            return;
        }
        if (!ClassUtils.isPresent((String)BEAN_CONFIGURER_ASPECT_CLASS_NAME, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
            throw new BeanDefinitionStoreException("org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect not found. \nCould not configure Spring Data JPA auditing-feature because spring-aspects.jar is not on the classpath!\nIf you want to use auditing please add spring-aspects.jar to the classpath.");
        }
        RootBeanDefinition def = new RootBeanDefinition();
        def.setBeanClassName(BEAN_CONFIGURER_ASPECT_CLASS_NAME);
        def.setFactoryMethodName("aspectOf");
        def.setRole(2);
        registry.registerBeanDefinition("org.springframework.context.config.internalBeanConfigurerAspect", new BeanComponentDefinition((BeanDefinition)def, "org.springframework.context.config.internalBeanConfigurerAspect").getBeanDefinition());
    }
}

