/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.eclipse.persistence.jpa.JpaQuery;
import org.hibernate.ejb.HibernateQuery;
import org.springframework.data.jpa.repository.query.QueryExtractor;
import org.springframework.data.jpa.repository.utils.JpaClassUtils;
import org.springframework.util.Assert;

public enum PersistenceProvider implements QueryExtractor
{
    HIBERNATE("org.hibernate.ejb.HibernateEntityManager"){

        @Override
        public String extractQueryString(Query query) {
            return ((HibernateQuery)query).getHibernateQuery().getQueryString();
        }

        @Override
        protected String getCountQueryPlaceholder() {
            return "*";
        }
    }
    ,
    ECLIPSELINK("org.eclipse.persistence.jpa.JpaEntityManager"){

        @Override
        public String extractQueryString(Query query) {
            return ((JpaQuery)query).getDatabaseQuery().getJPQLString();
        }
    }
    ,
    OPEN_JPA("org.apache.openjpa.persistence.OpenJPAEntityManager"){

        @Override
        public String extractQueryString(Query query) {
            return ((OpenJPAQuery)query).getQueryString();
        }
    }
    ,
    GENERIC_JPA("javax.persistence.EntityManager"){

        @Override
        public String extractQueryString(Query query) {
            return null;
        }

        @Override
        public boolean canExtractQuery() {
            return false;
        }
    };

    private String entityManagerClassName;

    private PersistenceProvider(String entityManagerClassName) {
        this.entityManagerClassName = entityManagerClassName;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull((Object)em);
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            if (!JpaClassUtils.isEntityManagerOfType(em, provider.entityManagerClassName)) continue;
            return provider;
        }
        return GENERIC_JPA;
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    protected String getCountQueryPlaceholder() {
        return "x";
    }
}

