/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.StreamUtils;

final class JpaResultConverters {
    private JpaResultConverters() {
    }

    static enum BlobToByteArrayConverter implements Converter<Blob, byte[]>
    {
        INSTANCE;


        public byte[] convert(Blob source) {
            if (source == null) {
                return null;
            }
            InputStream blobStream = null;
            try {
                blobStream = source.getBinaryStream();
                if (blobStream != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    StreamUtils.copy((InputStream)blobStream, (OutputStream)baos);
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
            }
            catch (SQLException e) {
                throw new DataRetrievalFailureException("Couldn't retrieve data from blob.", (Throwable)e);
            }
            catch (IOException e) {
                throw new DataRetrievalFailureException("Couldn't retrieve data from blob.", (Throwable)e);
            }
            finally {
                if (blobStream != null) {
                    try {
                        blobStream.close();
                    }
                    catch (IOException e) {
                        throw new CleanupFailureDataAccessException("Couldn't close binary stream for given blob.", (Throwable)e);
                    }
                }
            }
            return null;
        }
    }
}

