/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaMetamodelEntityInformation;
import org.springframework.data.jpa.repository.support.JpaPersistableEntityInformation;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaEntityInformationSupport<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements JpaEntityInformation<T, ID> {
    public JpaEntityInformationSupport(Class<T> domainClass) {
        super(domainClass);
    }

    public static <T> JpaEntityInformation<T, ?> getMetadata(Class<T> domainClass, EntityManager em) {
        Metamodel metamodel = em.getMetamodel();
        if (Persistable.class.isAssignableFrom(domainClass)) {
            return new JpaPersistableEntityInformation(domainClass, metamodel);
        }
        try {
            return new JpaMetamodelEntityInformation(domainClass, metamodel);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getEntityName() {
        Class domainClass = this.getJavaType();
        Entity entity = domainClass.getAnnotation(Entity.class);
        boolean hasName = null != entity && StringUtils.hasText((String)entity.name());
        return hasName ? entity.name() : domainClass.getSimpleName();
    }
}

