/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.repository.query.AbstractDelegatingRowMapper;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.mapping.event.AfterConvertCallback;
import org.springframework.data.relational.core.mapping.event.AfterConvertEvent;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;

public class CallbackCapableRowMapper<T>
extends AbstractDelegatingRowMapper<T> {
    private final ApplicationEventPublisher publisher;
    @Nullable
    private final EntityCallbacks callbacks;

    public CallbackCapableRowMapper(RowMapper<T> delegate, ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks) {
        super(delegate);
        this.publisher = publisher;
        this.callbacks = callbacks;
    }

    @Override
    @Nullable
    public T postProcessMapping(@Nullable T object) {
        if (object != null) {
            this.publisher.publishEvent((ApplicationEvent)new AfterConvertEvent(object));
            if (this.callbacks != null) {
                return (T)this.callbacks.callback(AfterConvertCallback.class, object, new Object[0]);
            }
        }
        return object;
    }
}

