/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping;

import org.springframework.data.jdbc.core.mapping.AggregateReference;
import org.springframework.data.jdbc.core.mapping.BasicJdbcPersistentProperty;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;

public class JdbcMappingContext
extends RelationalMappingContext {
    public JdbcMappingContext() {
        this.setSimpleTypeHolder(JdbcSimpleTypes.HOLDER);
    }

    public JdbcMappingContext(NamingStrategy namingStrategy) {
        super(namingStrategy);
        this.setSimpleTypeHolder(JdbcSimpleTypes.HOLDER);
    }

    public static JdbcMappingContext forPlainIdentifiers() {
        JdbcMappingContext context = JdbcMappingContext.forQuotedIdentifiers();
        context.setForceQuote(false);
        return context;
    }

    public static JdbcMappingContext forPlainIdentifiers(NamingStrategy namingStrategy) {
        JdbcMappingContext context = JdbcMappingContext.forQuotedIdentifiers(namingStrategy);
        context.setForceQuote(false);
        return context;
    }

    public static JdbcMappingContext forQuotedIdentifiers() {
        return new JdbcMappingContext();
    }

    public static JdbcMappingContext forQuotedIdentifiers(NamingStrategy namingStrategy) {
        return new JdbcMappingContext(namingStrategy);
    }

    protected RelationalPersistentProperty createPersistentProperty(Property property, RelationalPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        BasicJdbcPersistentProperty persistentProperty = new BasicJdbcPersistentProperty(property, (PersistentEntity<?, RelationalPersistentProperty>)owner, simpleTypeHolder, this.getNamingStrategy());
        this.applyDefaults(persistentProperty);
        return persistentProperty;
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return super.shouldCreatePersistentEntityFor(type) && !AggregateReference.class.isAssignableFrom(type.getType()) && !type.isCollectionLike();
    }
}

