/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.UUID;
import org.springframework.data.jdbc.core.mapping.schema.SqlTypeMapping;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.util.ClassUtils;

public class DefaultSqlTypeMapping
implements SqlTypeMapping {
    private final HashMap<Class<?>, String> typeMap = new HashMap();

    public DefaultSqlTypeMapping() {
        this.typeMap.put(String.class, "VARCHAR(255 BYTE)");
        this.typeMap.put(Boolean.class, "TINYINT");
        this.typeMap.put(Double.class, "DOUBLE");
        this.typeMap.put(Float.class, "FLOAT");
        this.typeMap.put(Integer.class, "INT");
        this.typeMap.put(Long.class, "BIGINT");
        this.typeMap.put(BigInteger.class, "BIGINT");
        this.typeMap.put(BigDecimal.class, "NUMERIC");
        this.typeMap.put(UUID.class, "UUID");
        this.typeMap.put(LocalDate.class, "DATE");
        this.typeMap.put(LocalTime.class, "TIME");
        this.typeMap.put(LocalDateTime.class, "TIMESTAMP");
        this.typeMap.put(ZonedDateTime.class, "TIMESTAMPTZ");
    }

    @Override
    public String getColumnType(RelationalPersistentProperty property) {
        return this.typeMap.get(ClassUtils.resolvePrimitiveIfNecessary((Class)property.getActualType()));
    }
}

