/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.RowDocumentResultSetExtractor;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;

public class EntityRowMapper<T>
implements RowMapper<T> {
    private final RelationalPersistentEntity<T> entity;
    private final AggregatePath path;
    private final JdbcConverter converter;
    @Nullable
    private final Identifier identifier;

    @Deprecated(since="3.2", forRemoval=true)
    public EntityRowMapper(PersistentPropertyPathExtension path, JdbcConverter converter, Identifier identifier) {
        this.entity = path.getLeafEntity();
        this.path = path.getAggregatePath();
        this.converter = converter;
        this.identifier = identifier;
    }

    public EntityRowMapper(AggregatePath path, JdbcConverter converter, Identifier identifier) {
        this.entity = path.getLeafEntity();
        this.path = path;
        this.converter = converter;
        this.identifier = identifier;
    }

    public EntityRowMapper(RelationalPersistentEntity<T> entity, JdbcConverter converter) {
        this.entity = entity;
        this.path = null;
        this.converter = converter;
        this.identifier = null;
    }

    public T mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
        RowDocument document = RowDocumentResultSetExtractor.toRowDocument(resultSet);
        return (T)(this.identifier == null ? this.converter.readAndResolve(this.entity.getType(), document) : this.converter.readAndResolve(this.entity.getType(), document, this.identifier));
    }
}

