/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.List;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.jdbc.core.JdbcAggregateChangeExecutionContext;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.DbActionExecutionException;

class AggregateChangeExecutor {
    private final JdbcConverter converter;
    private final DataAccessStrategy accessStrategy;

    AggregateChangeExecutor(JdbcConverter converter, DataAccessStrategy accessStrategy) {
        this.converter = converter;
        this.accessStrategy = accessStrategy;
    }

    <T> List<T> executeSave(AggregateChange<T> aggregateChange) {
        JdbcAggregateChangeExecutionContext executionContext = new JdbcAggregateChangeExecutionContext(this.converter, this.accessStrategy);
        aggregateChange.forEachAction(action -> this.execute((DbAction<?>)action, executionContext));
        return executionContext.populateIdsIfNecessary();
    }

    <T> void executeDelete(AggregateChange<T> aggregateChange) {
        JdbcAggregateChangeExecutionContext executionContext = new JdbcAggregateChangeExecutionContext(this.converter, this.accessStrategy);
        aggregateChange.forEachAction(action -> this.execute((DbAction<?>)action, executionContext));
    }

    private void execute(DbAction<?> action, JdbcAggregateChangeExecutionContext executionContext) {
        block16: {
            try {
                if (action instanceof DbAction.InsertRoot) {
                    executionContext.executeInsertRoot((DbAction.InsertRoot)action);
                    break block16;
                }
                if (action instanceof DbAction.BatchInsertRoot) {
                    executionContext.executeBatchInsertRoot((DbAction.BatchInsertRoot)action);
                    break block16;
                }
                if (action instanceof DbAction.Insert) {
                    executionContext.executeInsert((DbAction.Insert)action);
                    break block16;
                }
                if (action instanceof DbAction.BatchInsert) {
                    executionContext.executeBatchInsert((DbAction.BatchInsert)action);
                    break block16;
                }
                if (action instanceof DbAction.UpdateRoot) {
                    executionContext.executeUpdateRoot((DbAction.UpdateRoot)action);
                    break block16;
                }
                if (action instanceof DbAction.Delete) {
                    executionContext.executeDelete((DbAction.Delete)action);
                    break block16;
                }
                if (action instanceof DbAction.BatchDelete) {
                    executionContext.executeBatchDelete((DbAction.BatchDelete)action);
                    break block16;
                }
                if (action instanceof DbAction.DeleteAll) {
                    executionContext.executeDeleteAll((DbAction.DeleteAll)action);
                    break block16;
                }
                if (action instanceof DbAction.DeleteRoot) {
                    executionContext.executeDeleteRoot((DbAction.DeleteRoot)action);
                    break block16;
                }
                if (action instanceof DbAction.BatchDeleteRoot) {
                    executionContext.executeBatchDeleteRoot((DbAction.BatchDeleteRoot)action);
                    break block16;
                }
                if (action instanceof DbAction.DeleteAllRoot) {
                    executionContext.executeDeleteAllRoot((DbAction.DeleteAllRoot)action);
                    break block16;
                }
                if (action instanceof DbAction.AcquireLockRoot) {
                    executionContext.executeAcquireLock((DbAction.AcquireLockRoot)action);
                    break block16;
                }
                if (action instanceof DbAction.AcquireLockAllRoot) {
                    executionContext.executeAcquireLockAllRoot((DbAction.AcquireLockAllRoot)action);
                    break block16;
                }
                throw new RuntimeException("unexpected action");
            }
            catch (Exception e) {
                if (e instanceof OptimisticLockingFailureException) {
                    throw e;
                }
                throw new DbActionExecutionException(action, (Throwable)e);
            }
        }
    }
}

