/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.lang.reflect.Constructor;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.repository.query.AbstractJdbcQuery;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.SpelEvaluator;
import org.springframework.data.repository.query.SpelQueryContext;
import org.springframework.data.util.TypeInformation;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class StringBasedJdbcQuery
extends AbstractJdbcQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters; Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters";
    private final JdbcConverter converter;
    private final AbstractJdbcQuery.RowMapperFactory rowMapperFactory;
    private BeanFactory beanFactory;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper, JdbcConverter converter, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod, operations, (Class<?> result) -> defaultRowMapper, converter, evaluationContextProvider);
    }

    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, AbstractJdbcQuery.RowMapperFactory rowMapperFactory, JdbcConverter converter, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, operations);
        Assert.notNull((Object)rowMapperFactory, (String)"RowMapperFactory must not be null");
        this.converter = converter;
        this.rowMapperFactory = rowMapperFactory;
        this.evaluationContextProvider = evaluationContextProvider;
        if (queryMethod.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries; Offending method: " + queryMethod);
        }
        if (queryMethod.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries; Offending method: " + queryMethod);
        }
    }

    public Object execute(Object[] objects) {
        RelationalParametersParameterAccessor accessor = new RelationalParametersParameterAccessor((QueryMethod)this.getQueryMethod(), objects);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        JdbcQueryExecution.ResultProcessingConverter converter = new JdbcQueryExecution.ResultProcessingConverter(processor, this.converter.getMappingContext(), this.converter.getEntityInstantiators());
        JdbcQueryExecution<?> queryExecution = this.createJdbcQueryExecution((RelationalParameterAccessor)accessor, processor, converter);
        MapSqlParameterSource parameterMap = this.bindParameters((RelationalParameterAccessor)accessor);
        String query = this.determineQuery();
        if (ObjectUtils.isEmpty((Object)query)) {
            throw new IllegalStateException(String.format("No query specified on %s", this.getQueryMethod().getName()));
        }
        return queryExecution.execute(this.processSpelExpressions(objects, parameterMap, query), (SqlParameterSource)parameterMap);
    }

    private JdbcQueryExecution<?> createJdbcQueryExecution(RelationalParameterAccessor accessor, ResultProcessor processor, JdbcQueryExecution.ResultProcessingConverter converter) {
        if (this.getQueryMethod().isModifyingQuery()) {
            return this.createModifyingQueryExecutor();
        }
        RowMapper<Object> rowMapper = this.determineRowMapper(this.rowMapperFactory.create(this.resolveTypeToRead(processor)), converter, accessor.findDynamicProjection() != null);
        return this.createReadingQueryExecution(this.determineResultSetExtractor(rowMapper), rowMapper);
    }

    private String processSpelExpressions(Object[] objects, MapSqlParameterSource parameterMap, String query) {
        SpelQueryContext.EvaluatingSpelQueryContext queryContext = SpelQueryContext.of((counter, expression) -> String.format("__$synthetic$__%d", counter + 1), String::concat).withEvaluationContextProvider(this.evaluationContextProvider);
        SpelEvaluator spelEvaluator = queryContext.parse(query, (Parameters)this.getQueryMethod().getParameters());
        spelEvaluator.evaluate(objects).forEach((arg_0, arg_1) -> ((MapSqlParameterSource)parameterMap).addValue(arg_0, arg_1));
        return spelEvaluator.getQueryString();
    }

    private MapSqlParameterSource bindParameters(RelationalParameterAccessor accessor) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        Parameters bindableParameters = accessor.getBindableParameters();
        for (Parameter bindableParameter : bindableParameters) {
            this.convertAndAddParameter(parameters, bindableParameter, accessor.getBindableValue(bindableParameter.getIndex()));
        }
        return parameters;
    }

    private void convertAndAddParameter(MapSqlParameterSource parameters, Parameter p, Object value) {
        JdbcValue jdbcValue;
        String parameterName = (String)p.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
        RelationalParameters.RelationalParameter parameter = (RelationalParameters.RelationalParameter)this.getQueryMethod().getParameters().getParameter(p.getIndex());
        TypeInformation typeInformation = parameter.getTypeInformation();
        if (typeInformation.isCollectionLike() && value instanceof Collection) {
            ArrayList<Object> mapped = new ArrayList<Object>();
            SQLType jdbcType = null;
            TypeInformation actualType = typeInformation.getRequiredActualType();
            for (Object o : (Iterable)value) {
                JdbcValue elementJdbcValue = this.converter.writeJdbcValue(o, actualType.getType(), JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(actualType.getType())));
                if (jdbcType == null) {
                    jdbcType = elementJdbcValue.getJdbcType();
                }
                mapped.add(elementJdbcValue.getValue());
            }
            jdbcValue = JdbcValue.of(mapped, jdbcType);
        } else {
            jdbcValue = this.converter.writeJdbcValue(value, typeInformation.getType(), JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(typeInformation.getType())));
        }
        SQLType jdbcType = jdbcValue.getJdbcType();
        if (jdbcType == null) {
            parameters.addValue(parameterName, jdbcValue.getValue());
        } else {
            parameters.addValue(parameterName, jdbcValue.getValue(), jdbcType.getVendorTypeNumber().intValue());
        }
    }

    private String determineQuery() {
        String query = this.getQueryMethod().getDeclaredQuery();
        if (ObjectUtils.isEmpty((Object)query)) {
            throw new IllegalStateException(String.format("No query specified on %s", this.getQueryMethod().getName()));
        }
        return query;
    }

    @Nullable
    ResultSetExtractor<Object> determineResultSetExtractor(@Nullable RowMapper<Object> rowMapper) {
        String resultSetExtractorRef = this.getQueryMethod().getResultSetExtractorRef();
        if (!ObjectUtils.isEmpty((Object)resultSetExtractorRef)) {
            Assert.notNull((Object)this.beanFactory, (String)"When a ResultSetExtractorRef is specified the BeanFactory must not be null");
            return (ResultSetExtractor)this.beanFactory.getBean(resultSetExtractorRef);
        }
        Class<? extends ResultSetExtractor> resultSetExtractorClass = this.getQueryMethod().getResultSetExtractorClass();
        if (StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
            return null;
        }
        Constructor constructor = ClassUtils.getConstructorIfAvailable(resultSetExtractorClass, (Class[])new Class[]{RowMapper.class});
        if (constructor != null) {
            return (ResultSetExtractor)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{rowMapper});
        }
        return (ResultSetExtractor)BeanUtils.instantiateClass(resultSetExtractorClass);
    }

    @Nullable
    RowMapper<Object> determineRowMapper(@Nullable RowMapper<?> defaultMapper, Converter<Object, Object> resultProcessingConverter, boolean hasDynamicProjection) {
        RowMapper<Object> rowMapperToUse = this.determineRowMapper(defaultMapper);
        if ((hasDynamicProjection || rowMapperToUse == defaultMapper) && rowMapperToUse != null) {
            return new AbstractJdbcQuery.ConvertingRowMapper<Object>(rowMapperToUse, resultProcessingConverter);
        }
        return rowMapperToUse;
    }

    @Nullable
    RowMapper<Object> determineRowMapper(@Nullable RowMapper<?> defaultMapper) {
        String rowMapperRef = this.getQueryMethod().getRowMapperRef();
        if (!ObjectUtils.isEmpty((Object)rowMapperRef)) {
            Assert.notNull((Object)this.beanFactory, (String)"When a RowMapperRef is specified the BeanFactory must not be null");
            return (RowMapper)this.beanFactory.getBean(rowMapperRef);
        }
        Class<? extends RowMapper> rowMapperClass = this.getQueryMethod().getRowMapperClass();
        if (StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
            return defaultMapper;
        }
        return (RowMapper)BeanUtils.instantiateClass(rowMapperClass);
    }

    private static boolean isUnconfigured(@Nullable Class<?> configuredClass, Class<?> defaultClass) {
        return configuredClass == null || configuredClass == defaultClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

