/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.Array;
import java.sql.SQLType;
import org.springframework.data.jdbc.core.convert.JdbcArrayColumns;
import org.springframework.data.jdbc.core.convert.JdbcTypeFactory;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.Assert;

public class DefaultJdbcTypeFactory
implements JdbcTypeFactory {
    private final JdbcOperations operations;
    private final JdbcArrayColumns arrayColumns;

    public DefaultJdbcTypeFactory(JdbcOperations operations) {
        this(operations, JdbcArrayColumns.DefaultSupport.INSTANCE);
    }

    public DefaultJdbcTypeFactory(JdbcOperations operations, JdbcArrayColumns arrayColumns) {
        Assert.notNull((Object)operations, (String)"JdbcOperations must not be null");
        Assert.notNull((Object)arrayColumns, (String)"JdbcArrayColumns must not be null");
        this.operations = operations;
        this.arrayColumns = arrayColumns;
    }

    @Override
    public Array createArray(Object[] value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        Class<?> componentType = this.arrayColumns.getArrayType(value.getClass());
        SQLType jdbcType = JdbcUtil.targetSqlTypeFor(componentType);
        Assert.notNull((Object)jdbcType, () -> String.format("Couldn't determine JDBCType for %s", componentType));
        String typeName = this.arrayColumns.getArrayTypeName(jdbcType);
        return (Array)this.operations.execute(c -> c.createArrayOf(typeName, value));
    }
}

