/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;

abstract class FluentQuerySupport<S, R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Example<S> example;
    private final Sort sort;
    private final Class<R> resultType;
    private final List<String> fieldsToInclude;
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();

    FluentQuerySupport(Example<S> example, Sort sort, Class<R> resultType, List<String> fieldsToInclude) {
        this.example = example;
        this.sort = sort;
        this.resultType = resultType;
        this.fieldsToInclude = fieldsToInclude;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.create(this.example, sort, this.resultType, this.fieldsToInclude);
    }

    public <R> FluentQuery.FetchableFluentQuery<R> as(Class<R> projection) {
        Assert.notNull(projection, (String)"Projection target type must not be null!");
        return this.create(this.example, this.sort, projection, this.fieldsToInclude);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        Assert.notNull(properties, (String)"Projection properties must not be null!");
        return this.create(this.example, this.sort, this.resultType, new ArrayList<String>(properties));
    }

    protected abstract <R> FluentQuerySupport<S, R> create(Example<S> var1, Sort var2, Class<R> var3, List<String> var4);

    Class<S> getExampleType() {
        return this.example.getProbeType();
    }

    Example<S> getExample() {
        return this.example;
    }

    Sort getSort() {
        return this.sort;
    }

    Class<R> getResultType() {
        return this.resultType;
    }

    List<String> getFieldsToInclude() {
        return this.fieldsToInclude;
    }

    private Function<Object, R> getConversionFunction(Class<S> inputType, Class<R> targetType) {
        if (targetType.isAssignableFrom(inputType)) {
            return Function.identity();
        }
        if (targetType.isInterface()) {
            return o -> this.projectionFactory.createProjection(targetType, o);
        }
        return o -> DefaultConversionService.getSharedInstance().convert(o, targetType);
    }

    protected Function<Object, R> getConversionFunction() {
        return this.getConversionFunction(this.example.getProbeType(), this.getResultType());
    }
}

