/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.util.Streamable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class SimpleJdbcRepository<T, ID>
implements PagingAndSortingRepository<T, ID> {
    private final JdbcAggregateOperations entityOperations;
    private final PersistentEntity<T, ?> entity;

    public SimpleJdbcRepository(JdbcAggregateOperations entityOperations, PersistentEntity<T, ?> entity, JdbcConverter converter) {
        Assert.notNull((Object)entityOperations, (String)"EntityOperations must not be null.");
        Assert.notNull(entity, (String)"Entity must not be null.");
        this.entityOperations = entityOperations;
        this.entity = entity;
    }

    @Deprecated
    public SimpleJdbcRepository(JdbcAggregateOperations entityOperations, PersistentEntity<T, ?> entity) {
        Assert.notNull((Object)entityOperations, (String)"EntityOperations must not be null.");
        Assert.notNull(entity, (String)"Entity must not be null.");
        this.entityOperations = entityOperations;
        this.entity = entity;
    }

    @Transactional
    public <S extends T> S save(S instance) {
        return this.entityOperations.save(instance);
    }

    @Transactional
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return Streamable.of(entities).stream().map(this::save).collect(Collectors.toList());
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.entityOperations.findById(id, this.entity.getType()));
    }

    public boolean existsById(ID id) {
        return this.entityOperations.existsById(id, this.entity.getType());
    }

    public Iterable<T> findAll() {
        return this.entityOperations.findAll(this.entity.getType());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return this.entityOperations.findAllById(ids, this.entity.getType());
    }

    public long count() {
        return this.entityOperations.count(this.entity.getType());
    }

    @Transactional
    public void deleteById(ID id) {
        this.entityOperations.deleteById(id, this.entity.getType());
    }

    @Transactional
    public void delete(T instance) {
        this.entityOperations.delete(instance, this.entity.getType());
    }

    @Transactional
    public void deleteAllById(Iterable<? extends ID> ids) {
        ids.forEach(it -> this.entityOperations.deleteById(it, this.entity.getType()));
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(it -> this.entityOperations.delete(it, it.getClass()));
    }

    @Transactional
    public void deleteAll() {
        this.entityOperations.deleteAll(this.entity.getType());
    }

    public Iterable<T> findAll(Sort sort) {
        return this.entityOperations.findAll(this.entity.getType(), sort);
    }

    public Page<T> findAll(Pageable pageable) {
        return this.entityOperations.findAll(this.entity.getType(), pageable);
    }
}

