/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.JDBCType;
import java.util.Objects;
import org.springframework.lang.Nullable;

public final class JdbcValue {
    private final Object value;
    private final JDBCType jdbcType;

    private JdbcValue(@Nullable Object value, @Nullable JDBCType jdbcType) {
        this.value = value;
        this.jdbcType = jdbcType;
    }

    public static JdbcValue of(@Nullable Object value, @Nullable JDBCType jdbcType) {
        return new JdbcValue(value, jdbcType);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcValue jdbcValue = (JdbcValue)o;
        return Objects.equals(this.value, jdbcValue.value) && this.jdbcType == jdbcValue.jdbcType;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.jdbcType);
    }
}

