/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.Array;
import java.sql.JDBCType;
import org.springframework.data.jdbc.core.convert.JdbcTypeFactory;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.Assert;

public class DefaultJdbcTypeFactory
implements JdbcTypeFactory {
    private final JdbcOperations operations;

    public DefaultJdbcTypeFactory(JdbcOperations operations) {
        Assert.notNull((Object)operations, (String)"JdbcOperations must not be null");
        this.operations = operations;
    }

    @Override
    public Array createArray(Object[] value) {
        Assert.notNull((Object)value, (String)"Value must not be null.");
        Class<?> componentType = DefaultJdbcTypeFactory.innermostComponentType(value);
        JDBCType jdbcType = JdbcUtil.jdbcTypeFor(componentType);
        Assert.notNull((Object)jdbcType, () -> String.format("Couldn't determine JDBCType for %s", componentType));
        String typeName = jdbcType.getName();
        return (Array)this.operations.execute(c -> c.createArrayOf(typeName, value));
    }

    private static Class<?> innermostComponentType(Object convertedValue) {
        Class<?> componentType = convertedValue.getClass();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }
}

