/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

@Configuration
public class JdbcConfiguration {
    @Bean
    protected RelationalMappingContext jdbcMappingContext(Optional<NamingStrategy> namingStrategy) {
        RelationalMappingContext mappingContext = new RelationalMappingContext(namingStrategy.orElse(NamingStrategy.INSTANCE));
        mappingContext.setSimpleTypeHolder(this.jdbcCustomConversions().getSimpleTypeHolder());
        return mappingContext;
    }

    @Bean
    protected RelationalConverter relationalConverter(RelationalMappingContext mappingContext) {
        return new BasicRelationalConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, this.jdbcCustomConversions());
    }

    @Bean
    protected JdbcCustomConversions jdbcCustomConversions() {
        return new JdbcCustomConversions();
    }
}

