/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;

class MapEntityRowMapper<T>
implements RowMapper<Map.Entry<Object, T>> {
    private final RowMapper<T> delegate;
    private final String keyColumn;

    MapEntityRowMapper(RowMapper<T> delegate, String keyColumn) {
        this.delegate = delegate;
        this.keyColumn = keyColumn;
    }

    @NonNull
    public Map.Entry<Object, T> mapRow(ResultSet rs, int rowNum) throws SQLException {
        return new AbstractMap.SimpleEntry<Object, Object>(rs.getObject(this.keyColumn), this.delegate.mapRow(rs, rowNum));
    }
}

