/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.search.lucene;

import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneQueryException;
import org.apache.geode.cache.lucene.LuceneQueryFactory;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.gemfire.search.lucene.support.LuceneOperationsSupport;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class LuceneAccessor
extends LuceneOperationsSupport
implements InitializingBean {
    private GemFireCache gemfireCache;
    private LuceneIndex luceneIndex;
    private LuceneService luceneService;
    private Region<?, ?> region;
    private String indexName;
    private String regionPath;

    public LuceneAccessor() {
    }

    public LuceneAccessor(LuceneIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    public LuceneAccessor(String indexName, Region<?, ?> region) {
        this.indexName = indexName;
        this.region = region;
    }

    public LuceneAccessor(String indexName, String regionPath) {
        this.indexName = indexName;
        this.regionPath = regionPath;
    }

    public void afterPropertiesSet() throws Exception {
        this.gemfireCache = this.resolveCache();
        this.luceneService = this.resolveLuceneService();
        this.indexName = this.resolveIndexName();
        this.regionPath = this.resolveRegionPath();
    }

    public LuceneQueryFactory createLuceneQueryFactory() {
        return this.resolveLuceneService().createLuceneQueryFactory();
    }

    public LuceneQueryFactory createLuceneQueryFactory(int resultLimit) {
        return this.createLuceneQueryFactory(resultLimit, 0);
    }

    public LuceneQueryFactory createLuceneQueryFactory(int resultLimit, int pageSize) {
        return this.createLuceneQueryFactory().setLimit(resultLimit).setPageSize(pageSize);
    }

    protected GemFireCache resolveCache() {
        return Optional.ofNullable(this.getCache()).orElseGet(CacheUtils::resolveGemFireCache);
    }

    protected LuceneService resolveLuceneService() {
        return Optional.ofNullable(this.getLuceneService()).orElseGet(() -> this.resolveLuceneService(this.resolveCache()));
    }

    protected LuceneService resolveLuceneService(GemFireCache gemfireCache) {
        Assert.notNull((Object)gemfireCache, (String)"Cache reference was not properly configured");
        return LuceneServiceProvider.get((GemFireCache)gemfireCache);
    }

    protected String resolveIndexName() {
        String resolvedIndexName = Optional.ofNullable(this.getIndexName()).orElseGet(() -> SpringExtensions.safeGetValue(() -> this.getLuceneIndex().getName()));
        Assert.state((boolean)StringUtils.hasText((String)resolvedIndexName), (String)"The name of the Lucene Index could not be resolved");
        return resolvedIndexName;
    }

    protected String resolveRegionPath() {
        String resolvedRegionPath = Optional.ofNullable(this.getRegionPath()).orElseGet(() -> SpringExtensions.safeGetValue(() -> this.getRegion().getFullPath()));
        Assert.state((boolean)StringUtils.hasText((String)resolvedRegionPath), (String)"Region path could not be resolved");
        return resolvedRegionPath;
    }

    public <T extends LuceneAccessor> T setCache(GemFireCache gemfireCache) {
        this.gemfireCache = gemfireCache;
        return (T)this;
    }

    protected GemFireCache getCache() {
        return this.gemfireCache;
    }

    public <T extends LuceneAccessor> T setIndexName(String indexName) {
        this.indexName = indexName;
        return (T)this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public <T extends LuceneAccessor> T setLuceneIndex(LuceneIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
        return (T)this;
    }

    public LuceneIndex getLuceneIndex() {
        return this.luceneIndex;
    }

    public <T extends LuceneAccessor> T setLuceneService(LuceneService luceneService) {
        this.luceneService = luceneService;
        return (T)this;
    }

    protected LuceneService getLuceneService() {
        return this.luceneService;
    }

    public <T extends LuceneAccessor> T setRegion(Region<?, ?> region) {
        this.region = region;
        return (T)this;
    }

    public Region<?, ?> getRegion() {
        return this.region;
    }

    public <T extends LuceneAccessor> T setRegionPath(String regionPath) {
        this.regionPath = regionPath;
        return (T)this;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    protected <T> T doFind(LuceneQueryExecutor<T> queryExecutor, Object query, String regionPath, String indexName) {
        try {
            return queryExecutor.execute();
        }
        catch (LuceneQueryException e) {
            throw new DataRetrievalFailureException(String.format("Failed to execute Lucene Query [%1$s] on Region [%2$s] with Lucene Index [%3$s]", query, regionPath, indexName), (Throwable)e);
        }
    }

    @FunctionalInterface
    protected static interface LuceneQueryExecutor<T> {
        public T execute() throws LuceneQueryException;
    }
}

