/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.Regions;
import org.springframework.data.gemfire.mapping.annotation.Region;
import org.springframework.data.gemfire.repository.query.DefaultGemfireEntityInformation;
import org.springframework.data.gemfire.repository.query.GemfireEntityInformation;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.PartTreeGemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.StringBasedGemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.support.SimpleGemfireRepository;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemfireRepositoryFactory
extends RepositoryFactorySupport {
    private static final Class<Region> REGION_ANNOTATION = Region.class;
    static final String REGION_NOT_FOUND = "Region [%1$s] for Domain Type [%2$s] using Repository [%3$s] was not found; You must configure a Region with name [%1$s] in the application context";
    static final String REGION_REPOSITORY_ID_TYPE_MISMATCH = "Region [%1$s] requires keys of type [%2$s], but Repository [%3$s] declared an id of type [%4$s]";
    static final String REPOSITORY_ENTITY_ID_TYPE_MISMATCH = "Repository [%1$s] declared an id of type [%2$s], but entity [%3$s] has an id of type [%4$s]";
    private final MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext;
    private final Regions regions;

    public GemfireRepositoryFactory(@NonNull Iterable<org.apache.geode.cache.Region<?, ?>> regions, @NonNull MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext) {
        Assert.notNull(regions, (String)"Regions are required");
        Assert.notNull(mappingContext, (String)"MappingContext is required");
        this.regions = new Regions(regions, mappingContext);
        this.mappingContext = mappingContext;
    }

    protected MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected Regions getRegions() {
        return this.regions;
    }

    public <T, ID> GemfireEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new DefaultGemfireEntityInformation(this.resolvePersistentEntity(domainClass));
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleGemfireRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        GemfireTemplate gemfireTemplate = this.newTemplate((RepositoryMetadata)repositoryInformation);
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{gemfireTemplate, entityInformation});
    }

    protected GemfireTemplate newTemplate(RepositoryMetadata repositoryMetadata) {
        GemfirePersistentEntity entity = this.resolvePersistentEntity(repositoryMetadata.getDomainType());
        return new GemfireTemplate(this.validate(repositoryMetadata, entity, this.resolveRegion(repositoryMetadata, entity)));
    }

    @Nullable
    private <T> GemfirePersistentEntity<T> resolvePersistentEntity(Class<?> domainType) {
        return (GemfirePersistentEntity)this.getMappingContext().getPersistentEntity(domainType);
    }

    private org.apache.geode.cache.Region<?, ?> resolveRegion(RepositoryMetadata repositoryMetadata, GemfirePersistentEntity<?> entity) {
        String resolvedRegionName = this.getRepositoryRegionName(repositoryMetadata).orElseGet(() -> this.getEntityRegionName(repositoryMetadata, entity));
        return this.resolveRegion(repositoryMetadata, resolvedRegionName);
    }

    String getEntityRegionName(@NonNull RepositoryMetadata repositoryMetadata, @Nullable GemfirePersistentEntity<?> entity) {
        Optional<GemfirePersistentEntity<?>> optionalEntity = Optional.ofNullable(entity);
        return optionalEntity.map(GemfirePersistentEntity::getRegionName).filter(StringUtils::hasText).orElseGet(() -> optionalEntity.map(BasicPersistentEntity::getType).map(Class::getSimpleName).orElseGet(() -> repositoryMetadata.getDomainType().getSimpleName()));
    }

    Optional<String> getRepositoryRegionName(@NonNull RepositoryMetadata repositoryMetadata) {
        return Optional.ofNullable(repositoryMetadata).map(RepositoryMetadata::getRepositoryInterface).filter(repositoryInterface -> repositoryInterface.isAnnotationPresent(REGION_ANNOTATION)).map(repositoryInterface -> repositoryInterface.getAnnotation(REGION_ANNOTATION)).map(regionAnnotation -> regionAnnotation.value()).filter(StringUtils::hasText);
    }

    org.apache.geode.cache.Region<?, ?> resolveRegion(@NonNull RepositoryMetadata repositoryMetadata, String regionNamePath) {
        return Optional.ofNullable(this.getRegions().getRegion(regionNamePath)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException(REGION_NOT_FOUND, regionNamePath, repositoryMetadata.getDomainType().getName(), repositoryMetadata.getRepositoryInterface().getName()));
    }

    private org.apache.geode.cache.Region<?, ?> validate(RepositoryMetadata repositoryMetadata, GemfirePersistentEntity<?> entity, org.apache.geode.cache.Region<?, ?> region) {
        Assert.notNull(region, (String)"Region must not be null");
        Class repositoryIdType = repositoryMetadata.getIdType();
        Optional.ofNullable(region.getAttributes().getKeyConstraint()).ifPresent(regionKeyType -> Assert.isTrue((boolean)regionKeyType.isAssignableFrom(repositoryIdType), () -> String.format(REGION_REPOSITORY_ID_TYPE_MISMATCH, region.getFullPath(), regionKeyType.getName(), repositoryMetadata.getRepositoryInterface().getName(), repositoryIdType.getName())));
        Optional.ofNullable(entity).map(BasicPersistentEntity::getIdProperty).ifPresent(entityIdProperty -> Assert.isTrue((boolean)repositoryIdType.isAssignableFrom(entityIdProperty.getType()), () -> String.format(REPOSITORY_ENTITY_ID_TYPE_MISMATCH, repositoryMetadata.getRepositoryInterface().getName(), repositoryIdType.getName(), entityIdProperty.getOwner().getName(), entityIdProperty.getTypeName())));
        return region;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of((method, repositoryMetadata, projectionFactory, namedQueries) -> {
            GemfireQueryMethod queryMethod = (GemfireQueryMethod)((Object)((Object)this.newQueryMethod(method, repositoryMetadata, projectionFactory, evaluationContextProvider)));
            GemfireTemplate template = this.newTemplate(repositoryMetadata);
            String namedQueryName = queryMethod.getNamedQueryName();
            String query = namedQueries.hasQuery(namedQueryName) ? namedQueries.getQuery(namedQueryName) : (queryMethod.hasAnnotatedQuery() ? queryMethod.getAnnotatedQuery() : null);
            return StringUtils.hasText((String)query) ? new StringBasedGemfireRepositoryQuery(query, queryMethod, template).asUserDefinedQuery() : new PartTreeGemfireRepositoryQuery(queryMethod, template);
        });
    }

    protected <T extends QueryMethod> T newQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return (T)((Object)new GemfireQueryMethod(method, repositoryMetadata, projectionFactory, this.getMappingContext(), evaluationContextProvider));
    }
}

