/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.StreamSupport;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.LocatorLauncher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GemFireProperties;
import org.springframework.data.gemfire.config.annotation.LocatorConfigurer;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.support.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LocatorFactoryBean
extends AbstractFactoryBeanSupport<Locator>
implements InitializingBean {
    public static final int DEFAULT_PORT = 10334;
    public static final String DEFAULT_LOG_LEVEL = GemFireProperties.LOG_LEVEL.getDefaultValueAsString();
    private static final String LOCATORS_PROPERTY = GemFireProperties.LOCATORS.getName();
    public static final String LOG_LEVEL_PROPERTY = GemFireProperties.LOG_LEVEL.getName();
    private boolean useBeanFactoryLocator = false;
    private boolean useClusterConfigurationService = false;
    private Integer port = 10334;
    private final List<LocatorConfigurer> locatorConfigurers = new ArrayList<LocatorConfigurer>();
    private Locator locator;
    private final LocatorConfigurer compositeLocatorConfigurer = (beanName, bean) -> CollectionUtils.nullSafeList(this.locatorConfigurers).forEach(locatorConfigurer -> locatorConfigurer.configure(beanName, bean));
    private LocatorLauncher locatorLauncher;
    private Properties gemfireProperties;
    private String bindAddress;
    private String hostnameForClients;
    private String locators;
    private String logLevel;
    private String name;

    public void afterPropertiesSet() throws Exception {
        this.applyLocatorConfigurers();
        this.initializeBeanFactoryLocator();
        this.init();
    }

    protected void applyLocatorConfigurers() {
        this.applyLocatorConfigurers(this.getCompositeLocatorConfigurer());
    }

    protected void applyLocatorConfigurers(LocatorConfigurer ... locatorConfigurers) {
        this.applyLocatorConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(locatorConfigurers, LocatorConfigurer.class)));
    }

    protected void applyLocatorConfigurers(Iterable<LocatorConfigurer> locatorConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(locatorConfigurers).spliterator(), false).forEach(locatorConfigurer -> locatorConfigurer.configure(this.getBeanName(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ClassLoader currentThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getBeanClassLoader());
            LocatorLauncher.Builder locatorBuilder = this.configureGemfireProperties(this.newLocatorLauncherBuilder());
            this.getBindAddress().ifPresent(arg_0 -> ((LocatorLauncher.Builder)locatorBuilder).setBindAddress(arg_0));
            this.getHostnameForClients().ifPresent(arg_0 -> ((LocatorLauncher.Builder)locatorBuilder).setHostnameForClients(arg_0));
            this.getLocators().ifPresent(locators -> locatorBuilder.set(LOCATORS_PROPERTY, locators));
            this.getName().ifPresent(arg_0 -> ((LocatorLauncher.Builder)locatorBuilder).setMemberName(arg_0));
            locatorBuilder.set(LOG_LEVEL_PROPERTY, this.getLogLevel());
            locatorBuilder.setPort(this.getPort());
            LocatorLauncher.Builder processedLocatorBuilder = this.postProcess(locatorBuilder);
            this.locatorLauncher = this.postProcess(processedLocatorBuilder.build());
            LocatorLauncher.LocatorState locatorState = this.locatorLauncher.start();
            this.locator = this.locatorLauncher.getLocator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadContextClassLoader);
        }
    }

    protected LocatorLauncher.Builder configureGemfireProperties(LocatorLauncher.Builder locatorBuilder) {
        Properties gemfireProperties = this.getGemFireProperties();
        gemfireProperties.stringPropertyNames().stream().forEach(propertyName -> locatorBuilder.set(propertyName, gemfireProperties.getProperty((String)propertyName)));
        locatorBuilder.set(GemFireProperties.USE_CLUSTER_CONFIGURATION.getName(), String.valueOf(this.isUseClusterConfigurationService()));
        return locatorBuilder;
    }

    protected void initializeBeanFactoryLocator() {
        if (this.isUseBeanFactoryLocator()) {
            GemfireBeanFactoryLocator.newBeanFactoryLocator(this.getBeanFactory(), this.getBeanName());
        }
    }

    @NonNull
    protected LocatorLauncher.Builder newLocatorLauncherBuilder() {
        return new LocatorLauncher.Builder();
    }

    protected LocatorLauncher.Builder postProcess(LocatorLauncher.Builder locatorBuilder) {
        return locatorBuilder;
    }

    protected LocatorLauncher postProcess(LocatorLauncher locatorLauncher) {
        return locatorLauncher;
    }

    @Nullable
    public Locator getLocator() {
        return this.locator;
    }

    @Nullable
    public LocatorLauncher getLocatorLauncher() {
        return this.locatorLauncher;
    }

    @NonNull
    public Locator getObject() throws Exception {
        Locator locator = this.getLocator();
        Assert.state((locator != null ? 1 : 0) != 0, (String)"Locator was not configured and initialized");
        return locator;
    }

    @NonNull
    public Class<?> getObjectType() {
        Locator locator = this.getLocator();
        return locator != null ? locator.getClass() : Locator.class;
    }

    public void setBindAddress(@Nullable String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public Optional<String> getBindAddress() {
        return Optional.ofNullable(this.bindAddress).filter(StringUtils::hasText);
    }

    @NonNull
    public LocatorConfigurer getCompositeLocatorConfigurer() {
        return this.compositeLocatorConfigurer;
    }

    public void setGemFireProperties(@Nullable Properties gemfireProperties) {
        this.gemfireProperties = gemfireProperties;
    }

    @NonNull
    public Properties getGemFireProperties() {
        if (this.gemfireProperties == null) {
            this.gemfireProperties = new Properties();
        }
        return this.gemfireProperties;
    }

    public void setHostnameForClients(@Nullable String hostnameForClients) {
        this.hostnameForClients = hostnameForClients;
    }

    public Optional<String> getHostnameForClients() {
        return Optional.ofNullable(this.hostnameForClients).filter(StringUtils::hasText);
    }

    public void setLocatorConfigurers(LocatorConfigurer ... locatorConfigurers) {
        this.setLocatorConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(locatorConfigurers, LocatorConfigurer.class)));
    }

    public void setLocatorConfigurers(List<LocatorConfigurer> locatorConfigurers) {
        Optional.ofNullable(locatorConfigurers).ifPresent(this.locatorConfigurers::addAll);
    }

    public void setLocators(@Nullable String locators) {
        this.locators = locators;
    }

    public Optional<String> getLocators() {
        return Optional.ofNullable(this.locators).filter(StringUtils::hasText);
    }

    public void setLogLevel(@Nullable String logLevel) {
        this.logLevel = logLevel;
    }

    @NonNull
    public String getLogLevel() {
        return StringUtils.hasText((String)this.logLevel) ? this.logLevel : DEFAULT_LOG_LEVEL;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name).filter(StringUtils::hasText);
    }

    public void setPort(@NonNull Integer port) {
        this.port = this.assertPort(this.nullSafePort(port));
    }

    private int assertPort(@NonNull int port) {
        Assert.isTrue((port >= 0 && port < 65536 ? 1 : 0) != 0, (String)String.format("Network port [%d] is not valid", port));
        return port;
    }

    private int nullSafePort(@Nullable Integer port) {
        return port != null ? port : 10334;
    }

    @NonNull
    public Integer getPort() {
        return this.port;
    }

    public void setUseBeanFactoryLocator(boolean useBeanFactoryLocator) {
        this.useBeanFactoryLocator = useBeanFactoryLocator;
    }

    public boolean isUseBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    public void setUseClusterConfigurationService(boolean useClusterConfigurationService) {
        this.useClusterConfigurationService = useClusterConfigurationService;
    }

    public boolean isUseClusterConfigurationService() {
        return this.useClusterConfigurationService;
    }
}

