/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.io.File;
import java.util.Arrays;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public enum GemFireProperties {
    ACK_SEVERE_ALERT_THRESHOLD("ack-severe-alert-threshold", Long.class, 0),
    ACK_WAIT_THRESHOLD("ack-wait-threshold", Long.class, 15),
    ARCHIVE_DISK_SPACE_LIMIT("archive-disk-space-limit", Integer.class, 0),
    ARCHIVE_FILE_SIZE_LIMIT("archive-file-size-limit", Integer.class, 0),
    ASYNC_DISTRIBUTION_TIMEOUT("async-distribution-timeout", Long.class, 0),
    ASYNC_MAX_QUEUE_SIZE("async-max-queue-size", Integer.class, 8),
    ASYNC_QUEUE_TIMEOUT("async-queue-timeout", Long.class, 60000),
    BIND_ADDRESS("bind-address", String.class),
    CACHE_XML_FILE("cache-xml-file", String.class),
    CONFLATE_EVENTS("conflate-events", String.class, "server"),
    CONSERVE_SOCKETS("conserve-sockets", Boolean.class, true),
    DELTA_PROPAGATION("delta-propagation", Boolean.class, true),
    DEPLOY_WORKING_DIRECTORY("deploy-working-dir", File.class, new File(".")),
    DISABLE_AUTO_RECONNECT("disable-auto-reconnect", Boolean.class, false),
    DISABLE_JMX("disable-jmx", Boolean.class, false),
    DISABLE_TCP("disable-tcp", Boolean.class, false),
    DISTRIBUTED_SYSTEM_ID("distributed-system-id", Integer.class, -1),
    DISTRIBUTED_TRANSACTIONS("distributed-transactions", Boolean.class, false),
    DURABLE_CLIENT_ID("durable-client-id", String.class),
    DURABLE_CLIENT_TIMEOUT("durable-client-timeout", Long.class, 300L),
    ENABLE_CLUSTER_CONFIGURATION("enable-cluster-configuration", Boolean.class, true),
    ENABLE_MANAGEMENT_REST_SERVICE("enable-management-rest-service", Boolean.class, true),
    ENABLE_NETWORK_PARTITION_DETECTION("enable-network-partition-detection", Boolean.class, true),
    ENABLE_TIME_STATISTICS("enable-time-statistics", Boolean.class, false),
    ENFORCE_UNIQUE_HOST("enforce-unique-host", Boolean.class, false),
    GROUPS("groups", String.class),
    HTTP_SERVICE_BIND_ADDRESS("http-service-bind-address", String.class),
    HTTP_SERVICE_PORT("http-service-port", Integer.class, 7070),
    JMX_MANAGER("jmx-manager", Boolean.class, false),
    JMX_MANAGER_ACCESS_FILE("jmx-manager-access-file", File.class),
    JMX_MANAGER_BIND_ADDRESS("jmx-manager-bind-address", String.class),
    JMX_MANAGER_HOSTNAME_FOR_CLIENTS("jmx-manager-hostname-for-clients", String.class),
    JMX_MANAGER_PASSWORD_FILE("jmx-manager-password-file", File.class),
    JMX_MANAGER_PORT("jmx-manager-port", Integer.class, 1099),
    JMX_MANAGER_START("jmx-manager-start", Boolean.class, false),
    JMX_MANAGER_UPDATE_RATE("jmx-manager-update-rate", Long.class, 2000L),
    LOAD_CLUSTER_CONFIGURATION_FROM_DIR("load-cluster-configuration-from-dir", Boolean.class, false),
    LOCATOR_WAIT_TIME("locator-wait-time", Long.class, 0),
    LOCATORS("locators", String.class),
    LOCK_MEMORY("lock-memory", Boolean.class, false),
    LOG_DISK_SPACE_LIMIT("log-disk-space-limit", Integer.class, 0),
    LOG_FILE("log-file", String.class),
    LOG_FILE_SIZE_LIMIT("log-file-size-limit", Integer.class, 0),
    LOG_LEVEL("log-level", String.class, "config"),
    MAX_NUM_RECONNECT_TRIES("max-num-reconnect-tries", Integer.class, 3),
    MAX_WAIT_TIME_RECONNECT("max-wait-time-reconnect", Long.class, 60000),
    MCAST_ADDRESS("mcast-address", String.class, "239.192.81.1"),
    MCAST_FLOW_CONTROL("mcast-flow-control", String.class, "1048576,0.25, 5000"),
    MCAST_PORT("mcast-port", Integer.class, 10334),
    MCAST_RECV_BUFFER_SIZE("mcast-recv-buffer-size", Integer.class, 0x100000),
    MCAST_SEND_BUFFER_SIZE("mcast-send-buffer-size", Integer.class, 65535),
    MCAST_TTL("mcast-ttl", Integer.class, 32),
    MEMBER_TIMEOUT("member-timeout", Long.class, 5000L),
    MEMBERSHIP_PORT_RANGE("membership-port-range", String.class, "41000-61000"),
    MEMCACHED_BIND_ADDRESS("memcached-bind-address", String.class),
    MEMCACHED_PORT("memcached-port", Integer.class, 0),
    MEMCACHED_PROTOCOL("memcached-protocol", String.class, "ASCII"),
    NAME("name", String.class),
    OFF_HEAP_MEMORY_SIZE("off-heap-memory-size", Integer.class),
    REDUNDANCY_ZONE("redundancy-zone", String.class),
    REDIS_ENABLED("compatible-with-redis-enabled", Boolean.class),
    REDIS_BIND_ADDRESS("compatible-with-redis-bind-address", String.class),
    REDIS_PASSWORD("compatible-with-redis-password", String.class),
    REDIS_PORT("compatible-with-redis-port", Integer.class, 0),
    REMOTE_LOCATORS("remote-locators", String.class),
    REMOVE_UNRESPONSIVE_CLIENT("remove-unresponsive-client", Boolean.class, false),
    SECURITY_AUTH_TOKEN_ENABLED_COMPONENTS("security-auth-token-enabled-components", String[].class),
    SECURITY_CLIENT_AUTH_INIT("security-client-auth-init", String.class),
    SECURITY_LOG_FILE("security-log-file", File.class),
    SECURITY_LOG_LEVEL("security-log-level", String.class, "config"),
    SECURITY_MANAGER("security-manager", String.class),
    SECURITY_PEER_AUTH_INIT("security-peer-auth-init", String.class),
    SECURITY_PEER_VERIFY_MEMBER_TIMEOUT("security-peer-verifymember-timeout", Long.class, 1000L),
    SECURITY_POST_PROCESSOR("security-post-processor", String.class),
    SECURITY_SHIRO_INIT("security-shiro-init", String.class),
    SECURITY_UDP_DHALO("security-udp-dhalgo", String.class),
    SERIALIZABLE_OBJECT_FILTER("serializable-object-filter", String.class, "!*"),
    SERVER_BIND_ADDRESS("server-bind-address", String.class),
    SOCKET_BUFFER_SIZE("socket-buffer-size", Integer.class, 32768),
    SOCKET_LEASE_TIME("socket-lease-time", Long.class, 60000L),
    SSL_ENABLED_COMPONENTS("ssl-enabled-components", String.class, "all"),
    SSL_ENDPOINT_IDENTIFICATION_ENABLED("ssl-endpoint-identification-enabled", Boolean.class, false),
    SSL_REQUIRE_AUTHENTICATION("ssl-require-authentication", Boolean.class, true),
    SSL_CIPHERS("ssl-ciphers", String.class, "any"),
    SSL_CLUSTER_ALIAS("ssl-cluster-alias", String.class),
    SSL_DEFAULT_ALIAS("ssl-default-alias", String.class),
    SSL_GATEWAY_ALIAS("ssl-gateway-alias", String.class),
    SSL_JMX_ALIAS("ssl-jmx-alias", String.class),
    SSL_LOCATOR_ALIAS("ssl-locator-alias", String.class),
    SSL_PARAMETER_EXTENSION("ssl-parameter-extension", String.class),
    SSL_SERVER_ALIAS("ssl-server-alias", String.class),
    SSL_WEB_ALIAS("ssl-web-alias", String.class),
    SSL_WEB_SERVICE_REQUIRE_AUTHENTICATION("ssl-web-require-authentication", Boolean.class, false),
    SSL_KEYSTORE("ssl-keystore", String.class),
    SSL_KEYSTORE_PASSWORD("ssl-keystore-password", String.class),
    SSL_KEYSTORE_TYPE("ssl-keystore-type", String.class, "JKS"),
    SSL_PROTOCOLS("ssl-protocols", String.class, "any"),
    SSL_TRUSTSTORE("ssl-truststore", String.class),
    SSL_TRUSTSTORE_PASSWORD("ssl-truststore-password", String.class),
    SSL_TRUSTSTORE_TYPE("ssl-truststore-type", String.class, "JKS"),
    SSL_USE_DEFAULT_CONTEXT("ssl-use-default-context", Boolean.class, false),
    START_DEV_REST_API("start-dev-rest-api", Boolean.class, false),
    START_LOCATOR("start-locator", Boolean.class),
    STATISTIC_ARCHIVE_FILE("statistic-archive-file", File.class),
    STATISTIC_SAMPLE_RATE("statistic-sample-rate", Long.class, 1000),
    STATISTIC_SAMPLING_ENABLED("statistic-sampling-enabled", Boolean.class, false),
    TCP_PORT("tcp-port", Integer.class, 0),
    THREAD_MONITOR_ENABLED("thread-monitor-enabled", Boolean.class, true),
    THREAD_MONITOR_INTERVAL_MS("thread-monitor-interval-ms", Long.class, 0),
    THREAD_MONITOR_TIME_LIMIT("thread-monitor-time-limit-ms", Long.class, 30000),
    UDP_FRAGMENT_SIZE("udp-fragment-size", Integer.class, 60000),
    UDP_RECV_BUFFER_SIZE("udp-recv-buffer-size", Integer.class, 0x100000),
    UPD_SEND_BUFFER_SIZE("udp-send-buffer-size", Integer.class, 65535),
    USE_CLUSTER_CONFIGURATION("use-cluster-configuration", Boolean.class, true),
    USER_COMMAND_PACKAGES("user-command-packages", String.class),
    VALIDATE_SERIALIZABLE_OBJECTS("validate-serializable-objects", Boolean.class, false);

    private static final Class<?> DEFAULT_PROPERTY_TYPE;
    private static final Object DEFAULT_PROPERTY_VALUE;
    public static final String GEMFIRE_PROPERTY_NAME_PREFIX = "gemfire.";
    private final Class<?> propertyType;
    private final ConversionService conversionService;
    private final Object defaultValue;
    private final String propertyName;

    @NonNull
    public static GemFireProperties from(@Nullable String propertyName) {
        return Arrays.stream(GemFireProperties.values()).filter(it -> GemFireProperties.equals(it, propertyName)).findFirst().orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("[%s] is not a valid Apache Geode property", propertyName));
    }

    private static boolean equals(@Nullable GemFireProperties property, @Nullable String propertyName) {
        return property != null && property.getName().equals(GemFireProperties.normalizePropertyName(propertyName));
    }

    @Nullable
    private static String normalizePropertyName(@Nullable String propertyName) {
        String safePropertyName = String.valueOf(propertyName).trim();
        boolean gemfireDotPrefixed = safePropertyName.startsWith(GEMFIRE_PROPERTY_NAME_PREFIX);
        int index = safePropertyName.lastIndexOf(".");
        return gemfireDotPrefixed && index > -1 ? safePropertyName.substring(index + 1) : propertyName;
    }

    @Nullable
    private static Class<?> nullSafeType(@Nullable Object target, @Nullable Class<?> defaultType) {
        return target != null ? target.getClass() : defaultType;
    }

    private GemFireProperties(String propertyName, Class<?> propertyType) {
        this(propertyName, propertyType, null);
    }

    private GemFireProperties(@Nullable String propertyName, Class<?> propertyType, Object defaultValue) {
        Assert.hasText((String)propertyName, (String)"Property name is required");
        this.conversionService = DefaultConversionService.getSharedInstance();
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.defaultValue = defaultValue;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.defaultValue != null ? this.defaultValue : DEFAULT_PROPERTY_VALUE;
    }

    @NonNull
    public String getDefaultValueAsString() {
        return String.valueOf(this.getDefaultValue());
    }

    @NonNull
    public <T> T getDefaultValueAsType() {
        Class<?> propertyType = this.getType();
        return (T)this.getDefaultValueAsType(propertyType);
    }

    @NonNull
    public <T> T getDefaultValueAsType(@NonNull Class<T> type) {
        Assert.notNull(type, (String)"Target type must not be null");
        Object defaultValue = this.getDefaultValue();
        Class<?> propertyType = this.getType();
        Class<?> defaultValueType = GemFireProperties.nullSafeType(defaultValue, propertyType);
        if (type.isInstance(defaultValue)) {
            return type.cast(defaultValue);
        }
        if (this.conversionService.canConvert(defaultValueType, type)) {
            return (T)this.conversionService.convert(defaultValue, type);
        }
        throw RuntimeExceptionFactory.newIllegalArgumentException("Cannot convert value [%s] from type [%s] to type [%s]", defaultValue, defaultValueType, type);
    }

    @NonNull
    public String getName() {
        return this.propertyName;
    }

    @NonNull
    public Class<?> getType() {
        return this.propertyType != null ? this.propertyType : DEFAULT_PROPERTY_TYPE;
    }

    @NonNull
    public String toString() {
        return this.getName();
    }

    static {
        DEFAULT_PROPERTY_TYPE = Object.class;
        DEFAULT_PROPERTY_VALUE = null;
    }
}

