/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.gemfire.config.annotation.CacheServerConfigurer;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class CacheServerFactoryBean
extends AbstractFactoryBeanSupport<CacheServer>
implements DisposableBean,
InitializingBean,
SmartLifecycle {
    private boolean autoStartup = true;
    private boolean notifyBySubscription = true;
    private boolean tcpNoDelay = true;
    private int maxConnections = 800;
    private int maxMessageCount = 230000;
    private int maxThreads = 0;
    private int maxTimeBetweenPings = 60000;
    private int messageTimeToLive = 180;
    private int port = 40404;
    private int socketBufferSize = 32768;
    private int subscriptionCapacity = 1;
    private long loadPollInterval = 5000L;
    private Cache cache;
    private CacheServer cacheServer;
    private List<CacheServerConfigurer> cacheServerConfigurers = Collections.emptyList();
    private CacheServerConfigurer compositeCacheServerConfigurer = (beanName, bean) -> CollectionUtils.nullSafeCollection(this.cacheServerConfigurers).forEach(cacheServerConfigurer -> cacheServerConfigurer.configure(beanName, bean));
    private ServerLoadProbe serverLoadProbe = CacheServer.DEFAULT_LOAD_PROBE;
    private Set<InterestRegistrationListener> listeners = Collections.emptySet();
    private String bindAddress = "";
    private String hostNameForClients = "";
    private String subscriptionDiskStore;
    private String[] serverGroups = new String[0];
    private SubscriptionEvictionPolicy subscriptionEvictionPolicy = SubscriptionEvictionPolicy.DEFAULT;

    public void afterPropertiesSet() throws IOException {
        this.applyCacheServerConfigurers();
        Cache cache = this.resolveCache();
        this.cacheServer = this.postProcess(this.configure(this.addCacheServer(cache)));
    }

    private void applyCacheServerConfigurers() {
        this.applyCacheServerConfigurers(this.getCompositeCacheServerConfigurer());
    }

    protected void applyCacheServerConfigurers(CacheServerConfigurer ... cacheServerConfigurers) {
        this.applyCacheServerConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(cacheServerConfigurers, CacheServerConfigurer.class)));
    }

    protected void applyCacheServerConfigurers(Iterable<CacheServerConfigurer> cacheServerConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(cacheServerConfigurers).spliterator(), false).forEach(cacheServerConfigurer -> cacheServerConfigurer.configure(this.getBeanName(), this));
    }

    private Cache resolveCache() {
        return Optional.ofNullable(this.cache).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Cache is required", new Object[0]));
    }

    protected CacheServer addCacheServer(Cache cache) {
        return cache.addCacheServer();
    }

    protected CacheServer configure(CacheServer cacheServer) {
        cacheServer.setBindAddress(this.bindAddress);
        cacheServer.setGroups(this.serverGroups);
        cacheServer.setHostnameForClients(this.hostNameForClients);
        cacheServer.setLoadPollInterval(this.loadPollInterval);
        cacheServer.setLoadProbe(this.serverLoadProbe);
        cacheServer.setMaxConnections(this.maxConnections);
        cacheServer.setMaximumMessageCount(this.maxMessageCount);
        cacheServer.setMaximumTimeBetweenPings(this.maxTimeBetweenPings);
        cacheServer.setMaxThreads(this.maxThreads);
        cacheServer.setMessageTimeToLive(this.messageTimeToLive);
        cacheServer.setNotifyBySubscription(this.notifyBySubscription);
        cacheServer.setPort(this.port);
        cacheServer.setSocketBufferSize(this.socketBufferSize);
        cacheServer.setTcpNoDelay(this.tcpNoDelay);
        CollectionUtils.nullSafeCollection(this.listeners).forEach(arg_0 -> ((CacheServer)cacheServer).registerInterestRegistrationListener(arg_0));
        ClientSubscriptionConfig config = cacheServer.getClientSubscriptionConfig();
        config.setCapacity(this.subscriptionCapacity);
        this.getSubscriptionEvictionPolicy().setEvictionPolicy(config);
        Optional.ofNullable(this.subscriptionDiskStore).filter(StringUtils::hasText).ifPresent(arg_0 -> ((ClientSubscriptionConfig)config).setDiskStoreName(arg_0));
        return cacheServer;
    }

    protected CacheServer postProcess(CacheServer cacheServer) {
        return cacheServer;
    }

    protected CacheServerConfigurer getCompositeCacheServerConfigurer() {
        return this.compositeCacheServerConfigurer;
    }

    public CacheServer getObject() {
        return this.cacheServer;
    }

    public Class<?> getObjectType() {
        return this.cacheServer != null ? this.cacheServer.getClass() : CacheServer.class;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public boolean isRunning() {
        return this.cacheServer != null && this.cacheServer.isRunning();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void destroy() {
        this.stop();
        this.cacheServer = null;
    }

    public void start() {
        try {
            this.cacheServer.start();
        }
        catch (IOException e) {
            throw new BeanInitializationException("Cannot start cache server", (Throwable)e);
        }
    }

    public void stop() {
        Optional.ofNullable(this.cacheServer).ifPresent(CacheServer::stop);
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    void setCacheServer(CacheServer cacheServer) {
        this.cacheServer = cacheServer;
    }

    public void setCacheServerConfigurers(CacheServerConfigurer ... cacheServerConfigurers) {
        this.setCacheServerConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(cacheServerConfigurers, CacheServerConfigurer.class)));
    }

    public void setCacheServerConfigurers(List<CacheServerConfigurer> cacheServerConfigurers) {
        this.cacheServerConfigurers = Optional.ofNullable(cacheServerConfigurers).orElseGet(Collections::emptyList);
    }

    public void setHostNameForClients(String hostNameForClients) {
        this.hostNameForClients = hostNameForClients;
    }

    public void setListeners(Set<InterestRegistrationListener> listeners) {
        this.listeners = listeners;
    }

    public void setLoadPollInterval(long loadPollInterval) {
        this.loadPollInterval = loadPollInterval;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMaxMessageCount(int maxMessageCount) {
        this.maxMessageCount = maxMessageCount;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMaxTimeBetweenPings(int maxTimeBetweenPings) {
        this.maxTimeBetweenPings = maxTimeBetweenPings;
    }

    public void setMessageTimeToLive(int messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    public void setNotifyBySubscription(boolean notifyBySubscription) {
        this.notifyBySubscription = notifyBySubscription;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerGroups(String[] serverGroups) {
        this.serverGroups = serverGroups;
    }

    public void setServerLoadProbe(ServerLoadProbe serverLoadProbe) {
        this.serverLoadProbe = serverLoadProbe;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setSubscriptionCapacity(int subscriptionCapacity) {
        this.subscriptionCapacity = subscriptionCapacity;
    }

    public void setSubscriptionDiskStore(String diskStoreName) {
        this.subscriptionDiskStore = diskStoreName;
    }

    SubscriptionEvictionPolicy getSubscriptionEvictionPolicy() {
        return Optional.ofNullable(this.subscriptionEvictionPolicy).orElse(SubscriptionEvictionPolicy.DEFAULT);
    }

    public void setSubscriptionEvictionPolicy(SubscriptionEvictionPolicy evictionPolicy) {
        this.subscriptionEvictionPolicy = evictionPolicy;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }
}

