/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.SelectResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.GemfireRepository;
import org.springframework.data.gemfire.repository.Wrapper;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.repository.query.support.PagingUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RegionUtils;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleGemfireRepository<T, ID>
implements GemfireRepository<T, ID> {
    protected static final String SELECT_COUNT_OQL_QUERY = "SELECT count(*) FROM %s";
    private final EntityInformation<T, ID> entityInformation;
    private final GemfireTemplate template;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public SimpleGemfireRepository(@NonNull GemfireTemplate template, @NonNull EntityInformation<T, ID> entityInformation) {
        Assert.notNull((Object)template, (String)"GemfireTemplate must not be null");
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null");
        this.template = template;
        this.entityInformation = entityInformation;
    }

    @NonNull
    public EntityInformation<T, ID> getEntityInformation() {
        return this.entityInformation;
    }

    @NonNull
    public Logger getLogger() {
        return this.logger;
    }

    @NonNull
    public Region<ID, T> getRegion() {
        return this.getTemplate().getRegion();
    }

    @NonNull
    public GemfireTemplate getTemplate() {
        return this.template;
    }

    public <U extends T> U save(@NonNull U entity) {
        Object id = this.getEntityInformation().getRequiredId(entity);
        U existingValue = this.getTemplate().put(id, entity);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Overwrote existing value [{}] for ID [{}]", existingValue, id);
        }
        return entity;
    }

    @Override
    public T save(@NonNull Wrapper<T, ID> wrapper) {
        T entity = wrapper.getEntity();
        T existingValue = this.getTemplate().put(wrapper.getKey(), entity);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Overwrote existing value [{}] for ID [{}]", existingValue, wrapper.getKey());
        }
        return entity;
    }

    public <U extends T> Iterable<U> saveAll(@NonNull Iterable<U> entities) {
        EntityInformation entityInformation = this.getEntityInformation();
        HashMap entitiesToSave = new HashMap();
        Streamable.of(CollectionUtils.nullSafeIterable(entities)).stream().filter(Objects::nonNull).forEach(entity -> entitiesToSave.put(entityInformation.getRequiredId(entity), entity));
        if (!entitiesToSave.isEmpty()) {
            this.getTemplate().putAll(entitiesToSave);
        }
        return entitiesToSave.values();
    }

    public long count() {
        String regionPath = this.getRegion().getFullPath();
        String countQuery = String.format(SELECT_COUNT_OQL_QUERY, regionPath);
        SelectResults results = this.getTemplate().find(countQuery, new Object[0]);
        return Optional.ofNullable(results).map(Collection::iterator).filter(Iterator::hasNext).map(Iterator::next).map(Long::valueOf).orElse(0L);
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    @NonNull
    public Iterable<T> findAll() {
        String regionPath = this.getRegion().getFullPath();
        String query = String.format("SELECT * FROM %s", regionPath);
        SelectResults selectResults = this.getTemplate().find(query, new Object[0]);
        return this.toList(selectResults);
    }

    public Page<T> findAll(@NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        Iterable<T> results = this.findAll(pageable.getSort());
        return this.toPage(results, pageable);
    }

    @NonNull
    public Iterable<T> findAll(@NonNull Sort sort) {
        QueryString query = QueryString.of("SELECT * FROM /RegionPlaceholder").fromRegion(this.getRegion(), this.getEntityInformation().getJavaType()).orderBy(sort);
        SelectResults selectResults = this.getTemplate().find(query.toString(), new Object[0]);
        return this.toList(selectResults);
    }

    @NonNull
    public Iterable<T> findAllById(@NonNull Iterable<ID> ids) {
        List keys = (List)Streamable.of(CollectionUtils.nullSafeIterable(ids)).stream().filter(Objects::nonNull).collect(StreamUtils.toUnmodifiableList());
        Map keysValues = !keys.isEmpty() ? this.getTemplate().getAll(keys) : Collections.emptyMap();
        List values = CollectionUtils.nullSafeMap(keysValues).values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        return values;
    }

    public Optional<T> findById(@NonNull ID id) {
        Object value = id != null ? (Object)this.getTemplate().get(id) : null;
        return Optional.ofNullable(value);
    }

    public void delete(@NonNull T entity) {
        this.deleteById(this.getEntityInformation().getRequiredId(entity));
    }

    public void deleteAll() {
        this.getTemplate().execute(region -> {
            if (this.isPartitioned(region) || this.isTransactionPresent(region)) {
                this.doRegionClear(region);
            } else {
                SpringExtensions.safeDoOperation(() -> region.clear(), () -> this.doRegionClear(region));
            }
            return null;
        });
    }

    public void deleteAll(@NonNull Iterable<? extends T> entities) {
        CollectionUtils.nullSafeIterable(entities).forEach(this::delete);
    }

    public void deleteAllById(@NonNull Iterable<? extends ID> ids) {
        Set keys = StreamSupport.stream(CollectionUtils.nullSafeIterable(ids).spliterator(), false).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!keys.isEmpty()) {
            this.getTemplate().removeAll(keys);
        }
    }

    public void deleteById(@NonNull ID id) {
        this.getTemplate().remove(id);
    }

    boolean isPartitioned(@Nullable Region<?, ?> region) {
        return region != null && region.getAttributes() != null && this.isPartitioned(region.getAttributes().getDataPolicy());
    }

    boolean isPartitioned(@Nullable DataPolicy dataPolicy) {
        return dataPolicy != null && dataPolicy.withPartitioning();
    }

    boolean isTransactionPresent(@Nullable Region<?, ?> region) {
        return region != null && region.getRegionService() instanceof GemFireCache && this.isTransactionPresent(((GemFireCache)region.getRegionService()).getCacheTransactionManager());
    }

    boolean isTransactionPresent(@Nullable CacheTransactionManager cacheTransactionManager) {
        return cacheTransactionManager != null && cacheTransactionManager.exists();
    }

    <K> void doRegionClear(@NonNull Region<K, ?> region) {
        region.removeAll(this.resolveRegionKeys(region));
    }

    @NonNull
    <K> Set<K> resolveRegionKeys(@NonNull Region<K, ?> region) {
        return RegionUtils.isClient(region) ? region.keySetOnServer() : (RegionUtils.isServer(region) ? region.keySet() : Collections.emptySet());
    }

    @NonNull
    List<T> toList(@Nullable Iterable<T> iterable) {
        return iterable instanceof List ? (List)iterable : StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).collect(Collectors.toList());
    }

    @NonNull
    List<T> toList(@Nullable SelectResults<T> selectResults) {
        return selectResults != null ? CollectionUtils.nullSafeList(selectResults.asList()) : Collections.emptyList();
    }

    @NonNull
    Page<T> toPage(@Nullable Iterable<T> iterable, @NonNull Pageable pageable) {
        PagingUtils.assertPageable(pageable);
        List<T> results = this.toList(iterable);
        return PagingUtils.toPage(results, pageable);
    }
}

