/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.geode.cache.query.SelectResults;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.PagedSelectResults;
import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.repository.query.support.OqlQueryExecutor;
import org.springframework.data.gemfire.repository.query.support.PagingUtils;
import org.springframework.data.gemfire.repository.query.support.TemplateBasedOqlQueryExecutor;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class StringBasedGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private static final String INVALID_QUERY = "Modifying queries are not supported";
    private volatile boolean userDefinedQuery = false;
    private final GemfireTemplate template;
    private final OqlQueryExecutor nonPagedQueryExecutor;
    private final OqlQueryExecutor pagedQueryExecutor;
    private final QueryString query;

    StringBasedGemfireRepositoryQuery() {
        this.query = null;
        this.nonPagedQueryExecutor = (queryMethod, query, arguments) -> null;
        this.pagedQueryExecutor = (queryMethod, query, arguments) -> null;
        this.template = null;
        this.register(ProvidedQueryPostProcessors.LIMIT.processBefore(ProvidedQueryPostProcessors.IMPORT).processBefore(ProvidedQueryPostProcessors.HINT).processBefore(ProvidedQueryPostProcessors.TRACE));
    }

    public StringBasedGemfireRepositoryQuery(String query, GemfireQueryMethod queryMethod, GemfireTemplate template) {
        super(queryMethod);
        Assert.hasText((String)query, (String)"Query must not be null or empty");
        Assert.notNull((Object)template, (String)"GemfireTemplate must not be null");
        Assert.state((!queryMethod.isModifyingQuery() ? 1 : 0) != 0, (String)INVALID_QUERY);
        this.query = QueryString.of(query);
        this.template = template;
        this.nonPagedQueryExecutor = new TemplateBasedOqlQueryExecutor(template);
        this.pagedQueryExecutor = new SmartPagedOqlQueryExecutor(template).thenExecuteWith(new TwoPhasePagedOqlQueryExecutor(template).thenExecuteWith(new TemplateBasedOqlQueryExecutor(template)));
        this.register(ProvidedQueryPostProcessors.LIMIT.processBefore(ProvidedQueryPostProcessors.IMPORT).processBefore(ProvidedQueryPostProcessors.HINT).processBefore(ProvidedQueryPostProcessors.TRACE));
    }

    @NonNull
    public StringBasedGemfireRepositoryQuery asDerivedQuery() {
        this.userDefinedQuery = false;
        return this;
    }

    @NonNull
    public StringBasedGemfireRepositoryQuery asUserDefinedQuery() {
        this.userDefinedQuery = true;
        return this;
    }

    public boolean isDerivedQuery() {
        return !this.isUserDefinedQuery();
    }

    public boolean isUserDefinedQuery() {
        return this.userDefinedQuery;
    }

    @NonNull
    protected OqlQueryExecutor getNonPagedQueryExecutor() {
        return this.nonPagedQueryExecutor;
    }

    @NonNull
    protected OqlQueryExecutor getPagedQueryExecutor() {
        return this.pagedQueryExecutor;
    }

    @NonNull
    protected QueryString getQuery() {
        return this.query;
    }

    @NonNull
    protected GemfireTemplate getTemplate() {
        return this.template;
    }

    public Object execute(Object[] arguments) {
        QueryMethod queryMethod = this.getQueryMethod();
        QueryString query = this.getQuery();
        String preparedQuery = this.prepareQuery(queryMethod, query, arguments);
        SelectResults selectResults = this.resolveOqlQueryExecutor(queryMethod).execute(queryMethod, preparedQuery, arguments);
        return this.processQueryResults(queryMethod, selectResults, arguments);
    }

    @NonNull
    protected String prepareQuery(@NonNull QueryMethod queryMethod, @NonNull QueryString query, @NonNull Object[] arguments) {
        query = this.bindInParameters(queryMethod, this.resolveFromClause(queryMethod, query), arguments);
        String queryString = query.toString();
        String processedQueryString = this.getQueryPostProcessor().postProcess(queryMethod, queryString, arguments);
        return processedQueryString;
    }

    private QueryString bindInParameters(QueryMethod queryMethod, QueryString query, Object[] arguments) {
        Parameters queryMethodParameters = queryMethod.getParameters();
        ParametersParameterAccessor parameterAccessor = new ParametersParameterAccessor(queryMethodParameters, arguments);
        for (Integer index : query.getInParameterIndexes()) {
            query = query.bindIn(this.toCollection(parameterAccessor.getBindableValue(index - 1)));
        }
        return query;
    }

    private QueryString resolveFromClause(QueryMethod queryMethod, QueryString query) {
        return this.isUserDefinedQuery() ? query : query.fromRegion(this.getTemplate().getRegion(), queryMethod.getEntityInformation().getJavaType());
    }

    @NonNull
    protected OqlQueryExecutor resolveOqlQueryExecutor(@NonNull QueryMethod queryMethod) {
        return PagingUtils.isPagingPresent(queryMethod) ? this.getPagedQueryExecutor() : this.getNonPagedQueryExecutor();
    }

    @Nullable
    protected Object processQueryResults(@NonNull QueryMethod queryMethod, @NonNull SelectResults<?> selectResults, Object ... arguments) {
        Collection collection = this.toCollection(selectResults);
        if (queryMethod.isCollectionQuery()) {
            return collection;
        }
        if (queryMethod.isPageQuery()) {
            return new PageImpl(new ArrayList(collection), PagingUtils.getPageRequest(queryMethod, arguments), Integer.MAX_VALUE);
        }
        if (queryMethod.isQueryForEntity()) {
            if (collection.isEmpty()) {
                return null;
            }
            if (collection.size() == 1) {
                return collection.iterator().next();
            }
            throw new IncorrectResultSizeDataAccessException(1, collection.size());
        }
        if (this.isSingleNonEntityResult(queryMethod, collection)) {
            return collection.iterator().next();
        }
        throw RuntimeExceptionFactory.newIllegalStateException("Unsupported query: %s", this.query.toString());
    }

    private boolean isSingleNonEntityResult(QueryMethod method, Collection<?> result) {
        Class<Void> methodReturnType = method.getReturnedObjectType();
        methodReturnType = methodReturnType != null ? methodReturnType : Void.class;
        return CollectionUtils.nullSafeSize(result) == 1 && !Void.TYPE.equals(methodReturnType) && !method.isCollectionQuery();
    }

    @NonNull
    Collection toCollection(@Nullable Object source) {
        return source == null ? Collections.emptyList() : (source instanceof SelectResults ? ((SelectResults)source).asList() : (source instanceof Collection ? (Collection)source : (source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singletonList(source))));
    }

    static abstract class SimplePagedOqlQueryExecutor
    extends TemplateBasedOqlQueryExecutor {
        SimplePagedOqlQueryExecutor(@NonNull GemfireTemplate template) {
            super(template);
        }

        @Override
        @NonNull
        public SelectResults execute(@NonNull QueryMethod queryMethod, @NonNull String query, Object ... arguments) {
            if (PagingUtils.isPagingPresent(queryMethod)) {
                Pageable pageRequest = PagingUtils.getPageRequest(queryMethod, arguments);
                return this.doExecute(pageRequest, queryMethod, query, arguments);
            }
            throw this.newUnsupportedQueryExecutionException(query);
        }

        protected SelectResults doExecute(@NonNull Pageable pageRequest, @NonNull QueryMethod queryMethod, @NonNull String query, Object ... arguments) {
            String preparedQuery = this.preparePagedQuery(query, pageRequest);
            SelectResults selectResults = super.execute(queryMethod, preparedQuery, arguments);
            return this.processPagedQueryResults(selectResults, pageRequest);
        }

        @NonNull
        protected String preparePagedQuery(String query, Pageable pageRequest) {
            return query;
        }

        @NonNull
        protected SelectResults processPagedQueryResults(@NonNull SelectResults selectResults, @NonNull Pageable pageRequest) {
            return new PagedSelectResults(selectResults, pageRequest);
        }
    }

    class PageLimitingOqlQueryExecutor
    extends SimplePagedOqlQueryExecutor {
        PageLimitingOqlQueryExecutor(GemfireTemplate template) {
            super(template);
        }

        @Override
        protected String preparePagedQuery(String query, Pageable pageRequest) {
            String pagedQuery = super.preparePagedQuery(query, pageRequest);
            QueryString pagedQueryString = QueryString.of(pagedQuery);
            int pagedQueryResultSetLimit = PagingUtils.getQueryResultSetLimitForPage(pageRequest);
            if (pagedQueryString.isLimited()) {
                int queryLimit = pagedQueryString.getLimit();
                if (pagedQueryResultSetLimit < queryLimit) {
                    pagedQueryString = pagedQueryString.adjustLimit(pagedQueryResultSetLimit);
                } else {
                    int startIndex = PagingUtils.getQueryResultSetStartIndexForPage(pageRequest);
                    Assert.state((queryLimit > startIndex ? 1 : 0) != 0, () -> String.format("The user-defined OQL query result set LIMIT [%d] must be greater than the requested page offset [%d]", queryLimit, startIndex));
                    int endIndex = PagingUtils.getQueryResultSetEndIndexForPage(pageRequest);
                    if (queryLimit < endIndex) {
                        StringBasedGemfireRepositoryQuery.this.getLogger().warn(String.format("The requested page ending at index [%d] may be truncated by the user-defined OQL query result set LIMIT [%d]", endIndex, queryLimit));
                    }
                }
            } else {
                pagedQueryString = pagedQueryString.withLimit(pagedQueryResultSetLimit);
            }
            return pagedQueryString.toString();
        }
    }

    class SmartPagedOqlQueryExecutor
    extends PageLimitingOqlQueryExecutor {
        final int PAGED_QUERY_RESULT_SET_LIMIT_THRESHOLD;

        SmartPagedOqlQueryExecutor(GemfireTemplate template) {
            super(template);
            this.PAGED_QUERY_RESULT_SET_LIMIT_THRESHOLD = Integer.getInteger("spring.data.gemfire.query.limit.threshold", 101);
        }

        @Override
        protected SelectResults doExecute(Pageable pageRequest, QueryMethod queryMethod, String query, Object ... arguments) {
            if (this.isExecutable(pageRequest)) {
                return super.doExecute(pageRequest, queryMethod, query, arguments);
            }
            throw this.newUnsupportedQueryExecutionException(query);
        }

        protected boolean isExecutable(@NonNull Pageable pageRequest) {
            return PagingUtils.isPageOne(pageRequest) || PagingUtils.getQueryResultSetLimitForPage(pageRequest) < this.PAGED_QUERY_RESULT_SET_LIMIT_THRESHOLD;
        }
    }

    static class TwoPhasePagedOqlQueryExecutor
    extends SimplePagedOqlQueryExecutor {
        TwoPhasePagedOqlQueryExecutor(@NonNull GemfireTemplate template) {
            super(template);
        }

        @Override
        protected SelectResults processPagedQueryResults(SelectResults selectResults, Pageable pageRequest) {
            return super.processPagedQueryResults(selectResults, pageRequest);
        }
    }

    static enum ProvidedQueryPostProcessors implements QueryPostProcessor<Repository, String>
    {
        HINT{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasHint() && !QueryString.HINT_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withHints(gemfireQueryMethod.getHints()).toString();
                }
                return query;
            }
        }
        ,
        IMPORT{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasImport() && !QueryString.IMPORT_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withImport(gemfireQueryMethod.getImport()).toString();
                }
                return query;
            }
        }
        ,
        LIMIT{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasLimit() && !QueryString.LIMIT_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withLimit(gemfireQueryMethod.getLimit()).toString();
                }
                return query;
            }
        }
        ,
        TRACE{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasTrace() && !QueryString.TRACE_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withTrace().toString();
                }
                return query;
            }
        };

    }
}

