/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Optional;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class PagedQueryString
extends QueryString {
    private GemfireQueryMethod queryMethod;

    public static PagedQueryString of(@NonNull QueryString queryString) {
        Assert.notNull((Object)queryString, (String)"QueryString must not be null");
        return PagedQueryString.of(queryString.getQuery());
    }

    public static PagedQueryString of(@NonNull String query) {
        return new PagedQueryString(query);
    }

    public PagedQueryString(@NonNull String query) {
        super(query);
    }

    protected Optional<GemfireQueryMethod> getQueryMethod() {
        return Optional.ofNullable(this.queryMethod);
    }

    public PagedQueryString withQueryMethod(GemfireQueryMethod queryMethod) {
        this.queryMethod = queryMethod;
        return this;
    }
}

