/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.listener.ContinuousQueryListener;
import org.springframework.data.gemfire.listener.GemfireListenerExecutionFailedException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ContinuousQueryListenerAdapter
implements ContinuousQueryListener {
    public static final String DEFAULT_LISTENER_METHOD_NAME = "handleEvent";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MethodInvoker invoker;
    private Object delegate;
    private String defaultListenerMethod = "handleEvent";

    public ContinuousQueryListenerAdapter() {
        this.setDelegate(this);
    }

    public ContinuousQueryListenerAdapter(Object delegate) {
        this.setDelegate(delegate);
    }

    public final void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate is required");
        this.delegate = delegate;
        this.invoker = null;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
        this.invoker = null;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    protected String getListenerMethodName(CqEvent event) {
        return this.getDefaultListenerMethod();
    }

    @Override
    public void onEvent(CqEvent event) {
        try {
            Object delegate = this.getDelegate();
            if (delegate != this && delegate instanceof ContinuousQueryListener) {
                ((ContinuousQueryListener)delegate).onEvent(event);
            } else {
                String methodName = Optional.ofNullable(this.getListenerMethodName(event)).filter(StringUtils::hasText).orElseThrow(() -> new InvalidDataAccessApiUsageException("No default listener method specified; Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method."));
                this.invoker = Optional.ofNullable(this.invoker).orElseGet(() -> new MethodInvoker(this.delegate, methodName));
                this.invokeListenerMethod(event, methodName);
            }
        }
        catch (Throwable cause) {
            this.handleListenerException(cause);
        }
    }

    protected void handleListenerException(Throwable cause) {
        this.logger.error("Listener method execution failed", cause);
    }

    protected void invokeListenerMethod(CqEvent event, String methodName) {
        try {
            this.invoker.invoke(event);
        }
        catch (InvocationTargetException cause) {
            if (cause.getTargetException() instanceof DataAccessException) {
                throw (DataAccessException)cause.getTargetException();
            }
            throw new GemfireListenerExecutionFailedException(String.format("Listener method [%s] threw Exception", methodName), cause.getTargetException());
        }
        catch (Throwable cause) {
            throw new GemfireListenerExecutionFailedException(String.format("Failed to invoke the target listener method [%s]", methodName), cause);
        }
    }

    private static class MethodInvoker {
        private final Object delegate;
        private final List<Method> methods;

        MethodInvoker(Object delegate, String methodName) {
            Class<?> delegateType = delegate.getClass();
            this.delegate = delegate;
            this.methods = new ArrayList<Method>();
            ReflectionUtils.doWithMethods(delegateType, method -> {
                ReflectionUtils.makeAccessible((Method)method);
                this.methods.add(method);
            }, method -> this.isValidEventHandlerMethodSignature(method, methodName));
            Assert.isTrue((!this.methods.isEmpty() ? 1 : 0) != 0, (String)String.format("Cannot find a suitable method named [%1$s#%2$s]; Is the method public and does it have the proper arguments", delegateType.getName(), methodName));
        }

        private boolean isValidEventHandlerMethodSignature(Method method, String methodName) {
            return this.isValidEventHandlerMethodWithName(method, methodName) && this.isValidEventHandlerMethodWithSignature(method);
        }

        private boolean isValidEventHandlerMethodWithName(Method method, String methodName) {
            return Optional.ofNullable(method).filter(it -> Modifier.isPublic(it.getModifiers())).filter(it -> method.getName().equals(methodName)).isPresent();
        }

        private boolean isValidEventHandlerMethodWithSignature(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            int objects = 0;
            int operations = 0;
            if (parameterTypes.length > 0) {
                for (Class<?> parameterType : parameterTypes) {
                    if (Object.class.equals(parameterType)) {
                        if (++objects <= 2) continue;
                        return false;
                    }
                    if (Operation.class.equals(parameterType)) {
                        if (++operations <= 2) continue;
                        return false;
                    }
                    if (byte[].class.equals(parameterType) || CqEvent.class.equals(parameterType) || CqQuery.class.equals(parameterType) || Throwable.class.equals(parameterType)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        void invoke(CqEvent event) throws IllegalAccessException, InvocationTargetException {
            for (Method method : this.methods) {
                method.invoke(this.delegate, this.getMethodArguments(method, event));
            }
        }

        private Object[] getMethodArguments(Method method, CqEvent event) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] args = new Object[parameterTypes.length];
            boolean query = false;
            boolean value = false;
            for (int index = 0; index < parameterTypes.length; ++index) {
                Class<?> parameterType = parameterTypes[index];
                if (Object.class.equals(parameterType)) {
                    args[index] = value ? event.getNewValue() : event.getKey();
                    value = true;
                    continue;
                }
                if (Operation.class.equals(parameterType)) {
                    args[index] = query ? event.getQueryOperation() : event.getBaseOperation();
                    query = true;
                    continue;
                }
                if (byte[].class.equals(parameterType)) {
                    args[index] = event.getDeltaValue();
                    continue;
                }
                if (CqEvent.class.equals(parameterType)) {
                    args[index] = event;
                    continue;
                }
                if (CqQuery.class.equals(parameterType)) {
                    args[index] = event.getCq();
                    continue;
                }
                if (!Throwable.class.equals(parameterType)) continue;
                args[index] = event.getThrowable();
            }
            return args;
        }
    }
}

