/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import org.springframework.data.gemfire.function.annotation.OnMember;
import org.springframework.data.gemfire.function.annotation.OnMembers;
import org.springframework.data.gemfire.function.annotation.OnRegion;
import org.springframework.data.gemfire.function.annotation.OnServer;
import org.springframework.data.gemfire.function.annotation.OnServers;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.data.gemfire.function.config.OnMemberFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnMembersFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnRegionFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnServerFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnServersFunctionExecutionBeanDefinitionBuilder;

abstract class FunctionExecutionBeanDefinitionBuilderFactory {
    FunctionExecutionBeanDefinitionBuilderFactory() {
    }

    static AbstractFunctionExecutionBeanDefinitionBuilder newInstance(FunctionExecutionConfiguration configuration) {
        String functionExecutionAnnotation = configuration.getAnnotationType();
        if (OnMember.class.getName().equals(functionExecutionAnnotation)) {
            return new OnMemberFunctionExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnMembers.class.getName().equals(functionExecutionAnnotation)) {
            return new OnMembersFunctionExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnRegion.class.getName().equals(functionExecutionAnnotation)) {
            return new OnRegionFunctionExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnServer.class.getName().equals(functionExecutionAnnotation)) {
            return new OnServerFunctionExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnServers.class.getName().equals(functionExecutionAnnotation)) {
            return new OnServersFunctionExecutionBeanDefinitionBuilder(configuration);
        }
        return null;
    }
}

