/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.config.support.AbstractDependencyStructuringBeanFactoryPostProcessor;
import org.springframework.data.gemfire.util.SpringExtensions;

public class ClientRegionPoolBeanFactoryPostProcessor
extends AbstractDependencyStructuringBeanFactoryPostProcessor {
    protected static final String POOL_NAME_PROPERTY = "poolName";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashSet clientRegionBeanNames = new HashSet();
        HashSet poolBeanNames = new HashSet();
        Arrays.stream(beanFactory.getBeanDefinitionNames()).forEach(beanName -> {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (this.isClientRegionBean(beanDefinition)) {
                clientRegionBeanNames.add(beanName);
            } else if (this.isPoolBean(beanDefinition)) {
                poolBeanNames.add(beanName);
            }
        });
        clientRegionBeanNames.forEach(clientRegionBeanName -> {
            BeanDefinition clientRegionBean = beanFactory.getBeanDefinition(clientRegionBeanName);
            String poolName = this.getPoolName(clientRegionBean);
            if (poolBeanNames.contains(poolName)) {
                SpringExtensions.addDependsOn(clientRegionBean, poolName);
            }
        });
    }

    String getPoolName(BeanDefinition clientRegionBean) {
        return Optional.ofNullable(clientRegionBean.getPropertyValues().getPropertyValue(POOL_NAME_PROPERTY)).map(PropertyValue::getValue).map(String::valueOf).orElse(null);
    }
}

