/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.ResolvableRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableExpiration;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.expiration.AnnotationBasedExpiration;
import org.springframework.data.gemfire.expiration.ExpirationActionType;
import org.springframework.data.gemfire.expiration.ExpiringRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@Configuration
public class ExpirationConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final ExpirationActionType DEFAULT_ACTION = ExpirationActionType.DEFAULT;
    protected static final EnableExpiration.ExpirationType[] DEFAULT_EXPIRATION_TYPES = new EnableExpiration.ExpirationType[]{EnableExpiration.ExpirationType.IDLE_TIMEOUT, EnableExpiration.ExpirationType.TIME_TO_LIVE};
    private ExpirationPolicyConfigurer expirationPolicyConfigurer;

    @Override
    @NonNull
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableExpiration.class;
    }

    public void setImportMetadata(@NonNull AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableExpirationAttributes = this.getAnnotationAttributes(importMetadata);
            AnnotationAttributes[] policies = enableExpirationAttributes.getAnnotationArray("policies");
            for (AnnotationAttributes expirationPolicyAttributes : ArrayUtils.nullSafeArray(policies, AnnotationAttributes.class)) {
                this.expirationPolicyConfigurer = ComposableExpirationPolicyConfigurer.compose(this.expirationPolicyConfigurer, ExpirationPolicyMetaData.from(expirationPolicyAttributes));
            }
            this.expirationPolicyConfigurer = Optional.ofNullable(this.expirationPolicyConfigurer).orElseGet(ExpirationPolicyMetaData::fromDefaults);
        }
    }

    protected static boolean isRegionFactoryBean(Object bean) {
        return bean instanceof ExpiringRegionFactoryBean;
    }

    protected ExpirationPolicyConfigurer getExpirationPolicyConfigurer() {
        return Optional.ofNullable(this.expirationPolicyConfigurer).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("ExpirationPolicyConfigurer was not properly configured and initialized", new Object[0]));
    }

    @Bean
    public BeanPostProcessor expirationBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return ExpirationConfiguration.isRegionFactoryBean(bean) ? ExpirationConfiguration.this.getExpirationPolicyConfigurer().configure(bean) : bean;
            }
        };
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void expirationContextRefreshedListener(@NonNull ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        for (Region region : applicationContext.getBeansOfType(Region.class).values()) {
            this.getExpirationPolicyConfigurer().configure(region);
        }
    }

    protected static class ExpirationPolicyMetaData
    implements ExpirationPolicyConfigurer {
        protected static final String[] ALL_REGIONS = new String[0];
        private final ExpirationAttributes defaultExpirationAttributes;
        private final Set<String> regionNames = new HashSet<String>();
        private final Set<EnableExpiration.ExpirationType> types = new HashSet<EnableExpiration.ExpirationType>();

        protected static ExpirationPolicyMetaData from(AnnotationAttributes expirationPolicyAttributes) {
            Assert.isAssignable(EnableExpiration.ExpirationPolicy.class, (Class)expirationPolicyAttributes.annotationType());
            return ExpirationPolicyMetaData.newExpirationPolicyMetaData((Integer)expirationPolicyAttributes.get((Object)"timeout"), (ExpirationActionType)expirationPolicyAttributes.getEnum("action"), expirationPolicyAttributes.getStringArray("regionNames"), (EnableExpiration.ExpirationType[])expirationPolicyAttributes.get((Object)"types"));
        }

        protected static ExpirationPolicyMetaData from(EnableExpiration.ExpirationPolicy expirationPolicy) {
            return ExpirationPolicyMetaData.newExpirationPolicyMetaData(expirationPolicy.timeout(), expirationPolicy.action(), expirationPolicy.regionNames(), expirationPolicy.types());
        }

        protected static ExpirationPolicyMetaData fromDefaults() {
            return ExpirationPolicyMetaData.newExpirationPolicyMetaData(0, DEFAULT_ACTION, ALL_REGIONS, DEFAULT_EXPIRATION_TYPES);
        }

        protected static ExpirationAttributes newExpirationAttributes(int timeout, ExpirationActionType action) {
            return ExpirationPolicyMetaData.newExpirationAttributes(timeout, action.getExpirationAction());
        }

        protected static ExpirationAttributes newExpirationAttributes(int timeout, ExpirationAction action) {
            return new ExpirationAttributes(timeout, action);
        }

        protected static ExpirationPolicyMetaData newExpirationPolicyMetaData(int timeout, ExpirationActionType action, String[] regionNames, EnableExpiration.ExpirationType[] types) {
            return new ExpirationPolicyMetaData(ExpirationPolicyMetaData.newExpirationAttributes(timeout, action), CollectionUtils.asSet(ArrayUtils.nullSafeArray(regionNames, String.class)), CollectionUtils.asSet(ArrayUtils.nullSafeArray(types, EnableExpiration.ExpirationType.class)));
        }

        protected static ExpirationActionType resolveAction(ExpirationActionType action) {
            return action != null ? action : DEFAULT_ACTION;
        }

        protected static int resolveTimeout(int timeout) {
            return Math.max(timeout, 0);
        }

        protected ExpirationPolicyMetaData(int timeout, ExpirationActionType action, Set<String> regionNames, Set<EnableExpiration.ExpirationType> types) {
            this(ExpirationPolicyMetaData.newExpirationAttributes(ExpirationPolicyMetaData.resolveTimeout(timeout), ExpirationPolicyMetaData.resolveAction(action)), regionNames, types);
        }

        protected ExpirationPolicyMetaData(ExpirationAttributes expirationAttributes, Set<String> regionNames, Set<EnableExpiration.ExpirationType> types) {
            Assert.notEmpty(types, (String)"At least one ExpirationPolicy type [TTI, TTL] is required");
            this.defaultExpirationAttributes = expirationAttributes;
            this.regionNames.addAll(CollectionUtils.nullSafeSet(regionNames));
            this.types.addAll(CollectionUtils.nullSafeSet(types));
        }

        protected boolean accepts(Object regionBean) {
            return ExpirationConfiguration.isRegionFactoryBean(regionBean) && this.accepts(() -> this.resolveRegionName(regionBean));
        }

        protected boolean accepts(Region<?, ?> region) {
            return region != null && this.accepts(() -> region.getName());
        }

        protected boolean accepts(Supplier<String> regionName) {
            return this.regionNames.isEmpty() || this.regionNames.contains(regionName.get());
        }

        protected boolean isIdleTimeout() {
            return this.types.contains((Object)EnableExpiration.ExpirationType.IDLE_TIMEOUT);
        }

        protected boolean isTimeToLive() {
            return this.types.contains((Object)EnableExpiration.ExpirationType.TIME_TO_LIVE);
        }

        protected String resolveRegionName(Object regionFactoryBean) {
            return regionFactoryBean instanceof ResolvableRegionFactoryBean ? ((ResolvableRegionFactoryBean)regionFactoryBean).resolveRegionName() : null;
        }

        protected ExpiringRegionFactoryBean<?, ?> setExpirationAttributes(ExpiringRegionFactoryBean<?, ?> regionFactoryBean) {
            ExpirationAttributes defaultExpirationAttributes = this.defaultExpirationAttributes();
            if (this.isIdleTimeout()) {
                regionFactoryBean.setCustomEntryIdleTimeout(AnnotationBasedExpiration.forIdleTimeout(defaultExpirationAttributes));
            }
            if (this.isTimeToLive()) {
                regionFactoryBean.setCustomEntryTimeToLive(AnnotationBasedExpiration.forTimeToLive(defaultExpirationAttributes));
            }
            return regionFactoryBean;
        }

        @Override
        public Object configure(Object regionBean) {
            return this.accepts(regionBean) ? this.setExpirationAttributes(regionBean) : regionBean;
        }

        @Override
        public Region<?, ?> configure(Region<?, ?> region) {
            if (this.accepts(region)) {
                RegionAttributes regionAttributes = region.getAttributes();
                ExpirationAttributes expirationAttributes = this.defaultExpirationAttributes();
                AttributesMutator regionAttributesMutator = region.getAttributesMutator();
                if (SpringExtensions.areNotNull(regionAttributes, regionAttributesMutator)) {
                    CustomExpiry customEntryIdleTimeout = regionAttributes.getCustomEntryIdleTimeout();
                    CustomExpiry customEntryTimeToLive = regionAttributes.getCustomEntryTimeToLive();
                    if (this.isIdleTimeout() && customEntryIdleTimeout == null) {
                        regionAttributesMutator.setCustomEntryIdleTimeout(AnnotationBasedExpiration.forIdleTimeout(expirationAttributes));
                    }
                    if (this.isTimeToLive() && customEntryTimeToLive == null) {
                        regionAttributesMutator.setCustomEntryTimeToLive(AnnotationBasedExpiration.forTimeToLive(expirationAttributes));
                    }
                }
            }
            return region;
        }

        protected ExpirationAttributes defaultExpirationAttributes() {
            return this.defaultExpirationAttributes;
        }
    }

    protected static class ComposableExpirationPolicyConfigurer
    implements ExpirationPolicyConfigurer {
        private final ExpirationPolicyConfigurer one;
        private final ExpirationPolicyConfigurer two;

        protected static ExpirationPolicyConfigurer compose(ExpirationPolicyConfigurer[] array) {
            return ComposableExpirationPolicyConfigurer.compose(Arrays.asList(ArrayUtils.nullSafeArray(array, ExpirationPolicyConfigurer.class)));
        }

        protected static ExpirationPolicyConfigurer compose(Iterable<ExpirationPolicyConfigurer> iterable) {
            ExpirationPolicyConfigurer current = null;
            for (ExpirationPolicyConfigurer configurer : CollectionUtils.nullSafeIterable(iterable)) {
                current = ComposableExpirationPolicyConfigurer.compose(current, configurer);
            }
            return current;
        }

        protected static ExpirationPolicyConfigurer compose(ExpirationPolicyConfigurer one, ExpirationPolicyConfigurer two) {
            return one == null ? two : (two == null ? one : new ComposableExpirationPolicyConfigurer(one, two));
        }

        private ComposableExpirationPolicyConfigurer(@NonNull ExpirationPolicyConfigurer one, @NonNull ExpirationPolicyConfigurer two) {
            this.one = one;
            this.two = two;
        }

        @Override
        public Object configure(Object regionBean) {
            return this.two.configure(this.one.configure(regionBean));
        }

        @Override
        public Region<?, ?> configure(Region<?, ?> region) {
            return this.two.configure(this.one.configure(region));
        }
    }

    @FunctionalInterface
    protected static interface ExpirationPolicyConfigurer {
        public Object configure(Object var1);

        default public Region<?, ?> configure(Region<?, ?> region) {
            return region;
        }
    }
}

