/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.compression.Compressor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.gemfire.ConfigurableRegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.data.gemfire.client.support.BeanFactoryPoolResolver;
import org.springframework.data.gemfire.client.support.ComposablePoolResolver;
import org.springframework.data.gemfire.client.support.PoolManagerPoolResolver;
import org.springframework.data.gemfire.eviction.EvictingRegionFactoryBean;
import org.springframework.data.gemfire.expiration.ExpiringRegionFactoryBean;
import org.springframework.data.gemfire.support.SmartLifecycleSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.RegionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClientRegionFactoryBean<K, V>
extends ConfigurableRegionFactoryBean<K, V>
implements SmartLifecycleSupport,
EvictingRegionFactoryBean,
ExpiringRegionFactoryBean<K, V>,
DisposableBean {
    public static final String DEFAULT_POOL_NAME = "DEFAULT";
    public static final String GEMFIRE_POOL_NAME = "gemfirePool";
    private boolean close = false;
    private boolean destroy = false;
    private Boolean cloningEnabled;
    private Boolean concurrencyChecksEnabled;
    private Boolean diskSynchronous;
    private Boolean persistent;
    private Boolean statisticsEnabled;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private ClientRegionShortcut shortcut;
    private Compressor compressor;
    private CustomExpiry<K, V> customEntryIdleTimeout;
    private CustomExpiry<K, V> customEntryTimeToLive;
    private DataPolicy dataPolicy;
    private EvictionAttributes evictionAttributes;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private ExpirationAttributes regionIdleTimeout;
    private ExpirationAttributes regionTimeToLive;
    private Integer concurrencyLevel;
    private Integer initialCapacity;
    private Interest<K>[] interests;
    private Float loadFactor;
    private PoolResolver defaultPoolResolver;
    private PoolResolver poolResolver;
    private RegionAttributes<K, V> attributes;
    private String diskStoreName;
    private String poolName;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.initializePoolResolver();
        super.afterPropertiesSet();
    }

    void initializePoolResolver() {
        this.defaultPoolResolver = ComposablePoolResolver.compose((PoolResolver)new BeanFactoryPoolResolver(this.getBeanFactory()), (PoolResolver)new PoolManagerPoolResolver());
        this.poolResolver = this.poolResolver != null ? this.poolResolver : this.defaultPoolResolver;
    }

    @Override
    protected Region<K, V> createRegion(GemFireCache gemfireCache, String regionName) {
        ClientCache clientCache = this.resolveCache(gemfireCache);
        ClientRegionFactory<K, V> clientRegionFactory = this.postProcess(this.configure(this.createClientRegionFactory(clientCache, this.resolveClientRegionShortcut())));
        return this.newRegion(clientRegionFactory, this.getParent(), regionName);
    }

    private Region<K, V> newRegion(ClientRegionFactory<K, V> clientRegionFactory, Region<?, ?> parent, String regionName) {
        if (parent != null) {
            this.logInfo("Creating client Subregion [%1$s] with parent Region [%2$s]", regionName, parent.getName());
            return clientRegionFactory.createSubregion(parent, regionName);
        }
        this.logInfo("Creating client Region [%s]", regionName);
        return clientRegionFactory.create(regionName);
    }

    private ClientCache resolveCache(GemFireCache gemfireCache) {
        return Optional.ofNullable(gemfireCache).filter(CacheUtils::isClient).map(ClientCache.class::cast).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("ClientCache is required", new Object[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ClientRegionShortcut resolveClientRegionShortcut() {
        ClientRegionShortcut resolvedShortcut = this.shortcut;
        if (resolvedShortcut == null) {
            DataPolicy dataPolicy = this.dataPolicy;
            if (dataPolicy != null) {
                RegionUtils.assertDataPolicyAndPersistentAttributeAreCompatible(dataPolicy, this.persistent);
                if (DataPolicy.EMPTY.equals(dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.PROXY;
                } else if (DataPolicy.NORMAL.equals(dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.CACHING_PROXY;
                } else {
                    if (!DataPolicy.PERSISTENT_REPLICATE.equals(dataPolicy)) throw RuntimeExceptionFactory.newIllegalArgumentException("Data Policy [%s] is not valid for a client Region", dataPolicy);
                    resolvedShortcut = ClientRegionShortcut.LOCAL_PERSISTENT;
                }
            } else {
                resolvedShortcut = this.isPersistent() ? ClientRegionShortcut.LOCAL_PERSISTENT : ClientRegionShortcut.LOCAL;
            }
        }
        RegionUtils.assertClientRegionShortcutAndPersistentAttributeAreCompatible(resolvedShortcut, this.persistent);
        return resolvedShortcut;
    }

    private String resolvePoolName(String factoryPoolName, String attributesPoolName) {
        String resolvedPoolName = StringUtils.hasText((String)factoryPoolName) ? factoryPoolName : attributesPoolName;
        return Optional.ofNullable(resolvedPoolName).filter(StringUtils::hasText).filter(CacheUtils::isNotDefaultPool).map(it -> {
            Assert.isTrue((boolean)this.eagerlyInitializePool((String)it), (String)String.format("[%s] is not resolvable as a Pool in the application context", it));
            return it;
        }).orElse(null);
    }

    private boolean eagerlyInitializePool(String poolName) {
        return Optional.ofNullable(this.getPoolResolver().resolve(poolName)).map(it -> true).orElseGet(() -> SpringExtensions.safeGetValue(() -> this.getBeanFactory().getBean(poolName, Pool.class) != null, false));
    }

    protected ClientRegionFactory<K, V> createClientRegionFactory(ClientCache clientCache, ClientRegionShortcut clientRegionShortcut) {
        return clientCache.createClientRegionFactory(clientRegionShortcut);
    }

    protected ClientRegionFactory<K, V> configure(ClientRegionFactory<K, V> clientRegionFactory) {
        Optional<String> regionAttributesPoolName = this.configureWithRegionAttributes(clientRegionFactory);
        Arrays.stream(ArrayUtils.nullSafeArray(this.cacheListeners, CacheListener.class)).forEach(arg_0 -> clientRegionFactory.addCacheListener(arg_0));
        clientRegionFactory.setStatisticsEnabled(this.resolveStatisticsEnabled());
        Optional.ofNullable(this.cloningEnabled).ifPresent(arg_0 -> clientRegionFactory.setCloningEnabled(arg_0));
        Optional.ofNullable(this.compressor).ifPresent(arg_0 -> clientRegionFactory.setCompressor(arg_0));
        Optional.ofNullable(this.concurrencyChecksEnabled).ifPresent(arg_0 -> clientRegionFactory.setConcurrencyChecksEnabled(arg_0));
        Optional.ofNullable(this.concurrencyLevel).ifPresent(arg_0 -> clientRegionFactory.setConcurrencyLevel(arg_0));
        Optional.ofNullable(this.customEntryIdleTimeout).ifPresent(arg_0 -> clientRegionFactory.setCustomEntryIdleTimeout(arg_0));
        Optional.ofNullable(this.customEntryTimeToLive).ifPresent(arg_0 -> clientRegionFactory.setCustomEntryTimeToLive(arg_0));
        Optional.ofNullable(this.diskStoreName).filter(StringUtils::hasText).ifPresent(arg_0 -> clientRegionFactory.setDiskStoreName(arg_0));
        Optional.ofNullable(this.diskSynchronous).ifPresent(arg_0 -> clientRegionFactory.setDiskSynchronous(arg_0));
        Optional.ofNullable(this.entryIdleTimeout).ifPresent(arg_0 -> clientRegionFactory.setEntryIdleTimeout(arg_0));
        Optional.ofNullable(this.entryTimeToLive).ifPresent(arg_0 -> clientRegionFactory.setEntryTimeToLive(arg_0));
        Optional.ofNullable(this.evictionAttributes).ifPresent(arg_0 -> clientRegionFactory.setEvictionAttributes(arg_0));
        Optional.ofNullable(this.initialCapacity).ifPresent(arg_0 -> clientRegionFactory.setInitialCapacity(arg_0));
        Optional.ofNullable(this.keyConstraint).ifPresent(arg_0 -> clientRegionFactory.setKeyConstraint(arg_0));
        Optional.ofNullable(this.loadFactor).ifPresent(arg_0 -> clientRegionFactory.setLoadFactor(arg_0));
        Optional.ofNullable(this.resolvePoolName(this.getPoolName().orElse(null), regionAttributesPoolName.orElse(null))).ifPresent(arg_0 -> clientRegionFactory.setPoolName(arg_0));
        Optional.ofNullable(this.regionIdleTimeout).ifPresent(arg_0 -> clientRegionFactory.setRegionIdleTimeout(arg_0));
        Optional.ofNullable(this.regionTimeToLive).ifPresent(arg_0 -> clientRegionFactory.setRegionTimeToLive(arg_0));
        Optional.ofNullable(this.valueConstraint).ifPresent(arg_0 -> clientRegionFactory.setValueConstraint(arg_0));
        return clientRegionFactory;
    }

    private Optional<String> configureWithRegionAttributes(ClientRegionFactory<K, V> clientRegionFactory) {
        AtomicReference<Object> regionAttributesPoolName = new AtomicReference<Object>(null);
        Optional.ofNullable(this.getAttributes()).ifPresent(regionAttributes -> {
            regionAttributesPoolName.set(regionAttributes.getPoolName());
            Arrays.stream(ArrayUtils.nullSafeArray(regionAttributes.getCacheListeners(), CacheListener.class)).forEach(arg_0 -> ((ClientRegionFactory)clientRegionFactory).addCacheListener(arg_0));
            clientRegionFactory.setCloningEnabled(regionAttributes.getCloningEnabled());
            clientRegionFactory.setCompressor(regionAttributes.getCompressor());
            clientRegionFactory.setConcurrencyChecksEnabled(regionAttributes.getConcurrencyChecksEnabled());
            clientRegionFactory.setConcurrencyLevel(regionAttributes.getConcurrencyLevel());
            clientRegionFactory.setCustomEntryIdleTimeout(regionAttributes.getCustomEntryIdleTimeout());
            clientRegionFactory.setCustomEntryTimeToLive(regionAttributes.getCustomEntryTimeToLive());
            clientRegionFactory.setDiskStoreName(regionAttributes.getDiskStoreName());
            clientRegionFactory.setDiskSynchronous(regionAttributes.isDiskSynchronous());
            clientRegionFactory.setEntryIdleTimeout(regionAttributes.getEntryIdleTimeout());
            clientRegionFactory.setEntryTimeToLive(regionAttributes.getEntryTimeToLive());
            clientRegionFactory.setEvictionAttributes(regionAttributes.getEvictionAttributes());
            clientRegionFactory.setInitialCapacity(regionAttributes.getInitialCapacity());
            clientRegionFactory.setKeyConstraint(regionAttributes.getKeyConstraint());
            clientRegionFactory.setLoadFactor(regionAttributes.getLoadFactor());
            clientRegionFactory.setRegionIdleTimeout(regionAttributes.getRegionIdleTimeout());
            clientRegionFactory.setRegionTimeToLive(regionAttributes.getRegionTimeToLive());
            clientRegionFactory.setStatisticsEnabled(regionAttributes.getStatisticsEnabled());
            clientRegionFactory.setValueConstraint(regionAttributes.getValueConstraint());
        });
        return Optional.ofNullable(regionAttributesPoolName.get()).filter(StringUtils::hasText);
    }

    @Override
    protected ClientRegionFactory<K, V> postProcess(ClientRegionFactory<K, V> clientRegionFactory) {
        return clientRegionFactory;
    }

    @Override
    protected Region<K, V> postProcess(Region<K, V> region) {
        super.postProcess(region);
        Optional.ofNullable(this.cacheLoader).ifPresent(cacheLoader -> region.getAttributesMutator().setCacheLoader(cacheLoader));
        Optional.ofNullable(this.cacheWriter).ifPresent(cacheWriter -> region.getAttributesMutator().setCacheWriter(cacheWriter));
        return region;
    }

    public void start() {
        this.registerInterests(this.getRegion());
    }

    private Region<K, V> registerInterests(Region<K, V> region) {
        Arrays.stream(ArrayUtils.nullSafeArray(this.getInterests(), Interest.class)).forEach(interest -> {
            if (interest.isRegexType()) {
                region.registerInterestRegex((String)interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
            } else {
                region.registerInterest(interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
            }
        });
        return region;
    }

    public void destroy() throws Exception {
        Optional.ofNullable(this.getObject()).ifPresent(region -> {
            if (this.isClose() && RegionUtils.isCloseable(region)) {
                RegionUtils.close(region);
            }
            if (this.isDestroy()) {
                region.destroyRegion();
            }
        });
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    protected RegionAttributes<K, V> getAttributes() {
        return this.attributes;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setCloningEnabled(Boolean cloningEnabled) {
        this.cloningEnabled = cloningEnabled;
    }

    final boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
        this.destroy = this.destroy && !close;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    public void setConcurrencyChecksEnabled(Boolean concurrencyChecksEnabled) {
        this.concurrencyChecksEnabled = concurrencyChecksEnabled;
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    @Override
    public void setCustomEntryIdleTimeout(CustomExpiry<K, V> customEntryIdleTimeout) {
        this.customEntryIdleTimeout = customEntryIdleTimeout;
    }

    @Override
    public void setCustomEntryTimeToLive(CustomExpiry<K, V> customEntryTimeToLive) {
        this.customEntryTimeToLive = customEntryTimeToLive;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    final boolean isDestroy() {
        return this.destroy;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
        this.close = this.close && !destroy;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    @Override
    public void setEntryIdleTimeout(ExpirationAttributes entryIdleTimeout) {
        this.entryIdleTimeout = entryIdleTimeout;
    }

    @Override
    public void setEntryTimeToLive(ExpirationAttributes entryTimeToLive) {
        this.entryTimeToLive = entryTimeToLive;
    }

    @Override
    public void setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.evictionAttributes = evictionAttributes;
    }

    public void setInitialCapacity(Integer initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public void setInterests(Interest<K>[] interests) {
        this.interests = interests;
    }

    Interest<K>[] getInterests() {
        return this.interests;
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    public void setLoadFactor(Float loadFactor) {
        this.loadFactor = loadFactor;
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPool(Pool pool) {
        this.setPoolName(Optional.ofNullable(pool).map(Pool::getName).orElse(null));
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public Optional<String> getPoolName() {
        return Optional.ofNullable(this.poolName);
    }

    public void setPoolResolver(@Nullable PoolResolver poolResolver) {
        this.poolResolver = poolResolver;
    }

    @NonNull
    public PoolResolver getPoolResolver() {
        PoolResolver poolResolver = this.poolResolver;
        return poolResolver != null ? poolResolver : this.getDefaultPoolResolver();
    }

    @NonNull
    public PoolResolver getDefaultPoolResolver() {
        return this.defaultPoolResolver;
    }

    @Override
    public void setRegionIdleTimeout(ExpirationAttributes regionIdleTimeout) {
        this.regionIdleTimeout = regionIdleTimeout;
    }

    @Override
    public void setRegionTimeToLive(ExpirationAttributes regionTimeToLive) {
        this.regionTimeToLive = regionTimeToLive;
    }

    public void setShortcut(ClientRegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public void setStatisticsEnabled(Boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isStatisticsEnabled() {
        return Boolean.TRUE.equals(this.getStatisticsEnabled());
    }

    protected boolean resolveStatisticsEnabled() {
        return this.isStatisticsEnabled() || this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null || this.entryIdleTimeout != null || this.entryTimeToLive != null || this.regionIdleTimeout != null || this.regionTimeToLive != null || Optional.ofNullable(this.getAttributes()).map(RegionAttributes::getStatisticsEnabled).orElse(false) != false;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }
}

