/*
 * Copyright 2011-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.data.gemfire.listener;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.listener.adapter.ContinuousQueryListenerAdapter;

/**
 * Exception thrown when the execution of a listener method failed.
 *
 * @author Costin Leau
 * @see ContinuousQueryListenerAdapter
 */
@SuppressWarnings({ "serial", "unused" })
public class GemfireListenerExecutionFailedException extends InvalidDataAccessApiUsageException {

	/**
	 * Constructs a new <code>GemfireListenerExecutionFailedException</code> instance.
	 *
	 * @param message a String describing the cause of the exception.
	 */
	public GemfireListenerExecutionFailedException(String message) {
		super(message);
	}

	/**
	 * Constructs a new <code>GemfireListenerExecutionFailedException</code> instance.
	 *
	 * @param message a String describing the cause of the exception.
	 * @param cause a Throwable that was underlying cause of this exception.
	 */
	public GemfireListenerExecutionFailedException(String message, Throwable cause) {
		super(message, cause);
	}

}
