/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Arrays;
import java.util.function.Function;
import org.apache.geode.cache.Region;
import org.springframework.data.gemfire.RegionResolver;
import org.springframework.data.gemfire.support.AbstractCachingRegionResolver;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ComposableRegionResolver
extends AbstractCachingRegionResolver {
    private final RegionResolver regionResolverOne;
    private final RegionResolver regionResolverTwo;

    public static RegionResolver compose(RegionResolver ... regionResolvers) {
        return ComposableRegionResolver.compose(Arrays.asList(ArrayUtils.nullSafeArray(regionResolvers, RegionResolver.class)));
    }

    @Nullable
    public static RegionResolver compose(@Nullable Iterable<RegionResolver> regionResolvers) {
        RegionResolver current = null;
        for (RegionResolver regionResolver : CollectionUtils.nullSafeIterable(regionResolvers)) {
            current = ComposableRegionResolver.compose(current, regionResolver);
        }
        return current;
    }

    @Nullable
    public static RegionResolver compose(@Nullable RegionResolver one, @Nullable RegionResolver two) {
        return one == null ? two : (two == null ? one : new ComposableRegionResolver(one, two));
    }

    protected ComposableRegionResolver(@NonNull RegionResolver regionResolverOne, @NonNull RegionResolver regionResolverTwo) {
        Assert.notNull((Object)regionResolverOne, (String)"RegionResolver 1 must not be null");
        Assert.notNull((Object)regionResolverTwo, (String)"RegionResolver 2 must not be null");
        this.regionResolverOne = regionResolverOne;
        this.regionResolverTwo = regionResolverTwo;
    }

    @NonNull
    protected RegionResolver getRegionResolverOne() {
        return this.regionResolverOne;
    }

    @NonNull
    protected RegionResolver getRegionResolverTwo() {
        return this.regionResolverTwo;
    }

    @Override
    @Nullable
    protected <K, V> Region<K, V> doResolve(@Nullable String regionName) {
        Function<String, Region> regionResolverFunction = this.getRegionResolverTwo()::resolve;
        try {
            Region region = this.getRegionResolverOne().resolve(regionName);
            return region != null ? region : regionResolverFunction.apply(regionName);
        }
        catch (Throwable ignore) {
            return regionResolverFunction.apply(regionName);
        }
    }
}

