/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.util.Optional;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class DefinedIndexesApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Logger logger = this.initLogger();

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Optional.ofNullable(this.getQueryService(event)).ifPresent(queryService -> {
            try {
                queryService.createDefinedIndexes();
            }
            catch (MultiIndexCreationException cause) {
                this.logger.warn(String.format("Failed to create pre-defined Indexes: %s", cause.getMessage()), (Throwable)cause);
            }
        });
    }

    Logger initLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private QueryService getQueryService(ContextRefreshedEvent event) {
        String queryServiceBeanName;
        ApplicationContext applicationContext = event.getApplicationContext();
        return applicationContext.containsBean(queryServiceBeanName = this.getQueryServiceBeanName()) ? (QueryService)applicationContext.getBean(queryServiceBeanName, QueryService.class) : null;
    }

    private String getQueryServiceBeanName() {
        return "gemfireIndexDefinitionQueryService";
    }
}

