/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client.support;

import java.util.Arrays;
import org.apache.geode.cache.client.Pool;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ComposablePoolResolver
implements PoolResolver {
    private final PoolResolver poolResolverOne;
    private final PoolResolver poolResolverTwo;

    @Nullable
    public static PoolResolver compose(PoolResolver ... poolResolvers) {
        return ComposablePoolResolver.compose(Arrays.asList(ArrayUtils.nullSafeArray(poolResolvers, PoolResolver.class)));
    }

    @Nullable
    public static PoolResolver compose(@Nullable Iterable<PoolResolver> poolResolvers) {
        PoolResolver current = null;
        for (PoolResolver poolResolver : CollectionUtils.nullSafeIterable(poolResolvers)) {
            current = ComposablePoolResolver.compose(current, poolResolver);
        }
        return current;
    }

    @Nullable
    public static PoolResolver compose(@Nullable PoolResolver one, @Nullable PoolResolver two) {
        return one == null ? two : (two == null ? one : new ComposablePoolResolver(one, two));
    }

    protected ComposablePoolResolver(PoolResolver poolResolverOne, PoolResolver poolResolverTwo) {
        Assert.notNull((Object)poolResolverOne, (String)"PoolResolver 1 must not be null");
        Assert.notNull((Object)poolResolverTwo, (String)"PoolResolver 2 must not be null");
        this.poolResolverOne = poolResolverOne;
        this.poolResolverTwo = poolResolverTwo;
    }

    @NonNull
    protected PoolResolver getPoolResolverOne() {
        return this.poolResolverOne;
    }

    @NonNull
    protected PoolResolver getPoolResolverTwo() {
        return this.poolResolverTwo;
    }

    @Override
    @Nullable
    public Pool resolve(@Nullable String poolName) {
        Pool pool = this.getPoolResolverOne().resolve(poolName);
        return pool != null ? pool : this.getPoolResolverTwo().resolve(poolName);
    }
}

