/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Set;
import org.apache.geode.cache.Region;
import org.springframework.data.gemfire.function.execution.AbstractFunctionTemplate;
import org.springframework.data.gemfire.function.execution.GemfireOnRegionOperations;
import org.springframework.data.gemfire.function.execution.OnRegionFunctionExecution;
import org.springframework.util.Assert;

public class GemfireOnRegionFunctionTemplate
extends AbstractFunctionTemplate
implements GemfireOnRegionOperations {
    private final Region<?, ?> region;

    public GemfireOnRegionFunctionTemplate(Region<?, ?> region) {
        Assert.notNull(region, (String)"Region must not be null");
        this.region = region;
    }

    @Override
    protected OnRegionFunctionExecution getFunctionExecution() {
        return new OnRegionFunctionExecution(this.getRegion());
    }

    protected Region<?, ?> getRegion() {
        return this.region;
    }

    @Override
    public <T> Iterable<T> execute(String functionId, Set<?> keys, Object ... args) {
        return this.execute(this.getFunctionExecution().setKeys(keys).setArguments(args).setFunctionId(functionId).setTimeout(this.getTimeout()));
    }

    @Override
    public <T> T executeAndExtract(String functionId, Set<?> keys, Object ... args) {
        return this.executeAndExtract(this.getFunctionExecution().setKeys(keys).setFunctionId(functionId).setTimeout(this.getTimeout()).setArguments(args));
    }

    @Override
    public void executeWithNoResult(String functionId, Set<?> keys, Object ... args) {
        this.execute(this.getFunctionExecution().setKeys(keys).setArguments(args).setFunctionId(functionId).setTimeout(this.getTimeout()), false);
    }
}

