/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.gemfire.function.ExecutionTimeoutFunctionException;
import org.springframework.data.gemfire.function.UncategorizedFunctionException;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class AbstractFunctionExecution {
    private static final boolean DEFAULT_RETURN_RESULT = true;
    private static final String FUNCTION_EXECUTION_TIMEOUT_ERROR_MESSAGE = "Failed to collect Function [%1$s] results in the configured timeout [%2$d ms]";
    private static final String NO_RESULT_ERROR_MESSAGE = "Cannot return any result as the Function#hasResult() is false";
    private long timeout;
    private Function function;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Object[] arguments;
    private volatile ResultCollector<?, ?> resultCollector;
    private String functionId;

    public AbstractFunctionExecution(Function function, Object ... arguments) {
        Assert.notNull((Object)function, (String)"Function cannot be null");
        this.function = function;
        this.functionId = function.getId();
        this.arguments = arguments;
    }

    public AbstractFunctionExecution(String functionId, Object ... arguments) {
        Assert.hasText((String)functionId, (String)"Function ID must not be null or empty");
        this.function = null;
        this.functionId = functionId;
        this.arguments = arguments;
    }

    AbstractFunctionExecution() {
    }

    protected Object[] getArguments() {
        return this.arguments;
    }

    protected abstract Execution getExecution();

    protected Function getFunction() {
        return this.function;
    }

    protected String getFunctionId() {
        return this.functionId;
    }

    protected Set<?> getKeys() {
        return null;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected ResultCollector<?, ?> getResultCollector() {
        return this.resultCollector;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    String resolveFunctionIdentifier() {
        return Optional.ofNullable(this.getFunction()).map(ObjectUtils::nullSafeClassName).orElseGet(() -> this.getFunctionId());
    }

    <T> Iterable<T> execute() {
        return this.execute(true);
    }

    <T> Iterable<T> execute(Boolean returnResult) {
        ResultCollector resultCollector;
        Execution execution = this.prepare(this.getExecution());
        Function function = this.getFunction();
        ResultCollector resultCollector2 = resultCollector = function != null ? execution.execute(function) : execution.execute(this.getFunctionId());
        if (this.hasNoResult(returnResult, function, resultCollector)) {
            return null;
        }
        long timeout = this.getTimeout();
        this.logDebug("Configured timeout is [{} ms]", timeout);
        this.logDebug("Using ResultCollector [{}]", ObjectUtils.nullSafeClassName((Object)resultCollector));
        Iterable<T> results = null;
        try {
            Object result = timeout > 0L ? SpringUtils.safeGetValue(this.getResultWithTimeoutThrowableOperation(resultCollector, timeout), this.newFunctionAndInterruptedExceptionHandler(timeout)) : resultCollector.getResult();
            results = this.processResult(result);
            return results;
        }
        catch (FunctionException cause) {
            if (!cause.getMessage().contains(NO_RESULT_ERROR_MESSAGE)) {
                throw cause;
            }
            return results;
        }
    }

    protected Execution prepare(Execution execution) {
        execution = execution.setArguments((Object)this.getArguments());
        execution = this.getResultCollector() != null ? execution.withCollector(this.getResultCollector()) : execution;
        execution = this.getKeys() != null ? execution.withFilter(this.getKeys()) : execution;
        return execution;
    }

    private boolean hasResult(boolean returnResult, Function function, ResultCollector resultCollector) {
        return returnResult && (function == null || function.hasResult());
    }

    private boolean hasNoResult(boolean returnResult, Function function, ResultCollector resultCollector) {
        return !this.hasResult(returnResult, function, resultCollector);
    }

    private <T> SpringUtils.ValueReturningThrowableOperation<T> getResultWithTimeoutThrowableOperation(ResultCollector resultCollector, long timeout) {
        return () -> resultCollector.getResult(timeout, TimeUnit.MILLISECONDS);
    }

    private <T> java.util.function.Function<Throwable, T> newFunctionAndInterruptedExceptionHandler(long timeout) {
        return cause -> {
            if (cause instanceof FunctionException) {
                throw (FunctionException)((Object)cause);
            }
            if (cause instanceof InterruptedException) {
                String message = String.format(FUNCTION_EXECUTION_TIMEOUT_ERROR_MESSAGE, this.resolveFunctionIdentifier(), timeout);
                throw new ExecutionTimeoutFunctionException(message, (Throwable)cause);
            }
            throw new UncategorizedFunctionException((Throwable)cause);
        };
    }

    private <T> Iterable<T> processResult(Object result) {
        return this.replaceSingleNullElementIterableWithEmptyIterable(this.throwOnExceptionOrReturn((T)this.toIterable(this.throwOnExceptionOrReturn(result))));
    }

    private <T> Iterable<T> replaceSingleNullElementIterableWithEmptyIterable(Iterable<T> results) {
        if (results != null) {
            Iterator<T> it = results.iterator();
            if (!it.hasNext()) {
                return results;
            }
            if (it.next() == null && !it.hasNext()) {
                return Collections::emptyIterator;
            }
        }
        return results;
    }

    private <T> Iterable<T> throwOnExceptionOrReturn(Iterable<T> result) {
        Iterator<T> resultIterator = result.iterator();
        if (resultIterator.hasNext()) {
            this.throwOnExceptionOrReturn(resultIterator.next());
        }
        return result;
    }

    private <T> Iterable<T> toIterable(Object result) {
        return result instanceof Iterable ? (Set<Object>)result : Collections.singleton(result);
    }

    <T> T executeAndExtract() {
        Iterable<T> results = this.execute();
        if (this.isEmpty(results)) {
            return null;
        }
        T result = results.iterator().next();
        return this.throwOnExceptionOrReturn(result);
    }

    private boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    private <T> T throwOnExceptionOrReturn(T result) {
        if (result instanceof Throwable) {
            Function function = this.getFunction();
            String message = String.format("Execution of Function [%s] failed", function != null ? function.getClass().getName() : String.format("with ID [%s]", this.getFunctionId()));
            throw new FunctionException(message, (Throwable)result);
        }
        return result;
    }

    @Deprecated
    protected AbstractFunctionExecution setArgs(Object ... args) {
        return this.setArguments(args);
    }

    protected AbstractFunctionExecution setArguments(Object ... arguments) {
        this.arguments = arguments;
        return this;
    }

    protected AbstractFunctionExecution setFunction(Function function) {
        this.function = function;
        return this;
    }

    protected AbstractFunctionExecution setFunctionId(String functionId) {
        this.functionId = functionId;
        return this;
    }

    protected AbstractFunctionExecution setResultCollector(ResultCollector<?, ?> resultCollector) {
        this.resultCollector = resultCollector;
        return this;
    }

    protected AbstractFunctionExecution setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    protected void logDebug(String message, Object ... arguments) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(message, arguments);
        }
    }
}

