/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.data.gemfire.wan.GatewaySenderFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GatewaySenderParser
extends AbstractSimpleBeanDefinitionParser {
    GatewaySenderParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return GatewaySenderFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element eventSubstitutionFilterElement;
        String cacheRef = element.getAttribute("cache-ref");
        builder.addConstructorArgReference(SpringUtils.defaultIfEmpty(cacheRef, "gemfireCache"));
        ParsingUtils.setPropertyValue(element, builder, "name");
        ParsingUtils.setPropertyValue(element, builder, "alert-threshold");
        ParsingUtils.setPropertyValue(element, builder, "enable-batch-conflation", "batchConflationEnabled");
        ParsingUtils.setPropertyValue(element, builder, "batch-conflation-enabled");
        ParsingUtils.setPropertyValue(element, builder, "batch-size");
        ParsingUtils.setPropertyValue(element, builder, "batch-time-interval");
        ParsingUtils.setPropertyValue(element, builder, "disk-store-ref");
        ParsingUtils.setPropertyValue(element, builder, "disk-synchronous");
        ParsingUtils.setPropertyValue(element, builder, "dispatcher-threads");
        ParsingUtils.setPropertyValue(element, builder, "manual-start");
        ParsingUtils.setPropertyValue(element, builder, "maximum-queue-memory");
        ParsingUtils.setPropertyValue(element, builder, "order-policy");
        ParsingUtils.setPropertyValue(element, builder, "parallel");
        ParsingUtils.setPropertyValue(element, builder, "persistent");
        ParsingUtils.setPropertyValue(element, builder, "remote-distributed-system-id");
        ParsingUtils.setPropertyValue(element, builder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, builder, "socket-read-timeout");
        Element eventFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"event-filter");
        if (eventFilterElement != null) {
            builder.addPropertyValue("eventFilters", ParsingUtils.parseRefOrNestedBeanDeclaration(eventFilterElement, parserContext, builder));
        }
        if ((eventSubstitutionFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"event-substitution-filter")) != null) {
            builder.addPropertyValue("eventSubstitutionFilter", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(eventSubstitutionFilterElement, parserContext, builder));
        }
        ParsingUtils.parseTransportFilters(element, parserContext, builder);
        if (!StringUtils.hasText((String)element.getAttribute("name")) && element.getParentNode().getNodeName().endsWith("region")) {
            Element region = (Element)element.getParentNode();
            String regionName = StringUtils.hasText((String)region.getAttribute("name")) ? region.getAttribute("name") : region.getAttribute("id");
            int index = 0;
            String gatewaySenderName = regionName + ".gatewaySender#" + index;
            while (parserContext.getRegistry().isBeanNameInUse(gatewaySenderName)) {
                gatewaySenderName = regionName + ".gatewaySender#" + ++index;
            }
            builder.addPropertyValue("name", (Object)gatewaySenderName);
        }
    }
}

