/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Arrays;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@FunctionalInterface
public interface CompositeTypeFilter
extends TypeFilter {
    public static final CompositeTypeFilter ALLOW = (metadataReader, metadataReaderFactory) -> true;
    public static final CompositeTypeFilter DENY = (metadataReader, metadataReaderFactory) -> false;

    @NonNull
    default public CompositeTypeFilter andThen(@NonNull TypeFilter typeFilter) {
        Assert.notNull((Object)typeFilter, (String)"TypeFilter must not be null");
        return (metadataReader, metadataReaderFactory) -> this.match(metadataReader, metadataReaderFactory) && typeFilter.match(metadataReader, metadataReaderFactory);
    }

    @Nullable
    public static TypeFilter composeAnd(TypeFilter ... array) {
        return CompositeTypeFilter.composeAnd(Arrays.asList(ArrayUtils.nullSafeArray(array, TypeFilter.class)));
    }

    @Nullable
    public static TypeFilter composeAnd(@Nullable Iterable<TypeFilter> iterable) {
        CompositeTypeFilter current = null;
        for (TypeFilter typeFilter : CollectionUtils.nullSafeIterable(iterable)) {
            if (typeFilter == null) continue;
            current = current == null ? CompositeTypeFilter.of(typeFilter) : current.andThen(typeFilter);
        }
        return current;
    }

    @Nullable
    public static TypeFilter composeOr(TypeFilter ... array) {
        return CompositeTypeFilter.composeOr(Arrays.asList(ArrayUtils.nullSafeArray(array, TypeFilter.class)));
    }

    @Nullable
    public static TypeFilter composeOr(@Nullable Iterable<TypeFilter> iterable) {
        CompositeTypeFilter current = null;
        for (TypeFilter typeFilter : CollectionUtils.nullSafeIterable(iterable)) {
            if (typeFilter == null) continue;
            current = current == null ? CompositeTypeFilter.of(typeFilter) : current.orThen(typeFilter);
        }
        return current;
    }

    @NonNull
    public static CompositeTypeFilter of(@NonNull TypeFilter typeFilter) {
        Assert.notNull((Object)typeFilter, (String)"TypeFilter to wrap must not be null");
        return typeFilter instanceof CompositeTypeFilter ? (CompositeTypeFilter)typeFilter : (metadataReader, metadataReaderFactory) -> typeFilter.match(metadataReader, metadataReaderFactory);
    }

    @NonNull
    default public CompositeTypeFilter negate() {
        return (metadataReader, metadataReaderFactory) -> !this.match(metadataReader, metadataReaderFactory);
    }

    @NonNull
    default public CompositeTypeFilter orThen(@NonNull TypeFilter typeFilter) {
        return (metadataReader, metadataReaderFactory) -> this.match(metadataReader, metadataReaderFactory) || typeFilter.match(metadataReader, metadataReaderFactory);
    }
}

