/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnablePool;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposablePoolConfigurer;
import org.springframework.data.gemfire.config.annotation.PoolConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class AddPoolConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    @Autowired(required=false)
    private List<PoolConfigurer> poolConfigurers = Collections.emptyList();

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnablePool.class;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enablePoolAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.registerPoolFactoryBeanDefinition(enablePoolAttributes, registry);
        }
    }

    protected void registerPoolFactoryBeanDefinition(AnnotationAttributes enablePoolAttributes, BeanDefinitionRegistry registry) {
        String poolName = this.getAndValidatePoolName((Map<String, Object>)enablePoolAttributes);
        BeanDefinitionBuilder poolFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(PoolFactoryBean.class);
        poolFactoryBean.addPropertyValue("freeConnectionTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "free-connection-timeout"), this.resolveProperty(this.poolProperty("free-connection-timeout"), (Integer)enablePoolAttributes.getNumber("freeConnectionTimeout"))));
        poolFactoryBean.addPropertyValue("idleTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "idle-timeout"), this.resolveProperty(this.poolProperty("idle-timeout"), (Long)enablePoolAttributes.getNumber("idleTimeout"))));
        poolFactoryBean.addPropertyValue("loadConditioningInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "load-conditioning-interval"), this.resolveProperty(this.poolProperty("load-conditioning-interval"), (Integer)enablePoolAttributes.getNumber("loadConditioningInterval"))));
        poolFactoryBean.addPropertyValue("maxConnections", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "max-connections"), this.resolveProperty(this.poolProperty("max-connections"), (Integer)enablePoolAttributes.getNumber("maxConnections"))));
        poolFactoryBean.addPropertyValue("minConnections", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "min-connections"), this.resolveProperty(this.poolProperty("min-connections"), (Integer)enablePoolAttributes.getNumber("minConnections"))));
        poolFactoryBean.addPropertyValue("multiUserAuthentication", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "multi-user-authentication"), this.resolveProperty(this.poolProperty("multi-user-authentication"), enablePoolAttributes.getBoolean("multiUserAuthentication"))));
        poolFactoryBean.addPropertyValue("pingInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "ping-interval"), this.resolveProperty(this.poolProperty("ping-interval"), (Long)enablePoolAttributes.getNumber("pingInterval"))));
        poolFactoryBean.addPropertyValue("poolConfigurers", this.resolvePoolConfigurers());
        poolFactoryBean.addPropertyValue("prSingleHopEnabled", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "pr-single-hop-enabled"), this.resolveProperty(this.poolProperty("pr-single-hop-enabled"), enablePoolAttributes.getBoolean("prSingleHopEnabled"))));
        poolFactoryBean.addPropertyValue("readTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "read-timeout"), this.resolveProperty(this.poolProperty("read-timeout"), (Integer)enablePoolAttributes.getNumber("readTimeout"))));
        poolFactoryBean.addPropertyValue("retryAttempts", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "retry-attempts"), this.resolveProperty(this.poolProperty("retry-attempts"), (Integer)enablePoolAttributes.getNumber("retryAttempts"))));
        poolFactoryBean.addPropertyValue("serverGroup", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "server-group"), this.resolveProperty(this.poolProperty("server-group"), enablePoolAttributes.getString("serverGroup"))));
        poolFactoryBean.addPropertyValue("socketBufferSize", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "socket-buffer-size"), this.resolveProperty(this.poolProperty("socket-buffer-size"), (Integer)enablePoolAttributes.getNumber("socketBufferSize"))));
        poolFactoryBean.addPropertyValue("socketConnectTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "socket-connect-timeout"), this.resolveProperty(this.poolProperty("socket-connect-timeout"), (Integer)enablePoolAttributes.getNumber("socketConnectTimeout"))));
        poolFactoryBean.addPropertyValue("statisticInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "statistic-interval"), this.resolveProperty(this.poolProperty("statistic-interval"), (Integer)enablePoolAttributes.getNumber("statisticInterval"))));
        poolFactoryBean.addPropertyValue("subscriptionAckInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-ack-interval"), this.resolveProperty(this.poolProperty("subscription-ack-interval"), (Integer)enablePoolAttributes.getNumber("subscriptionAckInterval"))));
        poolFactoryBean.addPropertyValue("subscriptionEnabled", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-enabled"), this.resolveProperty(this.poolProperty("subscription-enabled"), enablePoolAttributes.getBoolean("subscriptionEnabled"))));
        poolFactoryBean.addPropertyValue("subscriptionMessageTrackingTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-message-tracking-timeout"), this.resolveProperty(this.poolProperty("subscription-message-tracking-timeout"), (Integer)enablePoolAttributes.getNumber("subscriptionMessageTrackingTimeout"))));
        poolFactoryBean.addPropertyValue("subscriptionRedundancy", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-redundancy"), this.resolveProperty(this.poolProperty("subscription-redundancy"), (Integer)enablePoolAttributes.getNumber("subscriptionRedundancy"))));
        poolFactoryBean.addPropertyValue("threadLocalConnections", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "thread-local-connections"), this.resolveProperty(this.poolProperty("thread-local-connections"), enablePoolAttributes.getBoolean("threadLocalConnections"))));
        this.configurePoolConnections(poolName, enablePoolAttributes, poolFactoryBean);
        registry.registerBeanDefinition(poolName, (BeanDefinition)poolFactoryBean.getBeanDefinition());
    }

    private List<PoolConfigurer> resolvePoolConfigurers() {
        return Optional.ofNullable(this.poolConfigurers).filter(poolConfigurers -> !poolConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposablePoolConfigurer.create(this.getBeanFactory())));
    }

    protected String getAndValidatePoolName(Map<String, Object> enablePoolAttributes) {
        return Optional.ofNullable((String)enablePoolAttributes.get("name")).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Pool name is required", new Object[0]));
    }

    protected BeanDefinitionBuilder configurePoolConnections(String poolName, AnnotationAttributes enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        this.configurePoolLocators(poolName, enablePoolAttributes, poolFactoryBean);
        this.configurePoolServers(poolName, enablePoolAttributes, poolFactoryBean);
        return poolFactoryBean;
    }

    protected BeanDefinitionBuilder configurePoolLocators(String poolName, AnnotationAttributes enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        String locatorsFromProperty = this.resolveProperty(this.namedPoolProperty(poolName, "locators"), this.resolveProperty(this.poolProperty("locators"), (String)null));
        ConnectionEndpointList locators = Optional.ofNullable(locatorsFromProperty).filter(StringUtils::hasText).map(it -> ConnectionEndpointList.parse(10334, it.split(","))).orElseGet(() -> this.parseConnectionEndpoints(enablePoolAttributes, "locators", "locatorsString", 10334));
        poolFactoryBean.addPropertyValue("locators", (Object)locators);
        return poolFactoryBean;
    }

    protected BeanDefinitionBuilder configurePoolServers(String poolName, AnnotationAttributes enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        String serversFromProperty = this.resolveProperty(this.namedPoolProperty(poolName, "servers"), this.resolveProperty("servers", (String)null));
        ConnectionEndpointList servers = Optional.ofNullable(serversFromProperty).filter(StringUtils::hasText).map(it -> ConnectionEndpointList.parse(40404, it.split(","))).orElseGet(() -> this.parseConnectionEndpoints(enablePoolAttributes, "servers", "serversString", 40404));
        poolFactoryBean.addPropertyValue("servers", (Object)servers);
        return poolFactoryBean;
    }

    protected ConnectionEndpointList parseConnectionEndpoints(AnnotationAttributes enablePoolAttributes, String arrayAttributeName, String stringAttributeName, int defaultPort) {
        AnnotationAttributes[] connectionEndpointsMetaData = enablePoolAttributes.getAnnotationArray(arrayAttributeName);
        ConnectionEndpointList connectionEndpoints = new ConnectionEndpointList();
        Arrays.stream(ArrayUtils.nullSafeArray(connectionEndpointsMetaData, AnnotationAttributes.class)).forEach(annotationAttributes -> connectionEndpoints.add(this.newConnectionEndpoint((String)annotationAttributes.get((Object)"host"), (Integer)annotationAttributes.get((Object)"port"))));
        Optional.ofNullable(enablePoolAttributes.getString(stringAttributeName)).filter(StringUtils::hasText).ifPresent(hostsPorts -> connectionEndpoints.add(ConnectionEndpointList.parse(defaultPort, hostsPorts.split(","))));
        return connectionEndpoints;
    }

    protected ConnectionEndpoint newConnectionEndpoint(String host, Integer port) {
        return new ConnectionEndpoint(host, port);
    }
}

