/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.distributed.ServerLauncherCacheProvider;
import org.springframework.data.gemfire.support.SpringContextBootstrappingInitializer;

public class SpringServerLauncherCacheProvider
implements ServerLauncherCacheProvider {
    public Cache createCache(Properties gemfireProperties, ServerLauncher serverLauncher) {
        Cache cache = null;
        if (serverLauncher.isSpringXmlLocationSpecified()) {
            System.setProperty(this.gemfireName(), serverLauncher.getMemberName());
            this.newSpringContextBootstrappingInitializer().init(this.createParameters(serverLauncher));
            cache = (Cache)SpringContextBootstrappingInitializer.getApplicationContext().getBean(Cache.class);
        }
        return cache;
    }

    Properties createParameters(ServerLauncher serverLauncher) {
        Properties parameters = new Properties();
        parameters.setProperty("contextConfigLocations", serverLauncher.getSpringXmlLocation());
        return parameters;
    }

    String gemfireName() {
        return "gemfire.name";
    }

    SpringContextBootstrappingInitializer newSpringContextBootstrappingInitializer() {
        return new SpringContextBootstrappingInitializer();
    }
}

