/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MethodInvokingBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.support.ClientRegionPoolBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PoolParser
extends AbstractSingleBeanDefinitionParser {
    static final AtomicBoolean INFRASTRUCTURE_COMPONENTS_REGISTERED = new AtomicBoolean(false);
    static final int DEFAULT_LOCATOR_PORT = 10334;
    static final int DEFAULT_SERVER_PORT = 40404;
    static final String DEFAULT_HOST = "localhost";
    static final String HOST_ATTRIBUTE_NAME = "host";
    static final String LOCATOR_ELEMENT_NAME = "locator";
    static final String LOCATORS_ATTRIBUTE_NAME = "locators";
    static final String PORT_ATTRIBUTE_NAME = "port";
    static final String SERVER_ELEMENT_NAME = "server";
    static final String SERVERS_ATTRIBUTE_NAME = "servers";

    PoolParser() {
    }

    private static void registerInfrastructureComponents(ParserContext parserContext) {
        if (INFRASTRUCTURE_COMPONENTS_REGISTERED.compareAndSet(false, true)) {
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ClientRegionPoolBeanFactoryPostProcessor.class).setRole(2).getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
    }

    protected Class<?> getBeanClass(Element element) {
        return PoolFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder poolBuilder) {
        PoolParser.registerInfrastructureComponents(parserContext);
        ParsingUtils.setPropertyValue(element, poolBuilder, "free-connection-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "idle-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "keep-alive");
        ParsingUtils.setPropertyValue(element, poolBuilder, "load-conditioning-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "max-connections");
        ParsingUtils.setPropertyValue(element, poolBuilder, "min-connections");
        ParsingUtils.setPropertyValue(element, poolBuilder, "multi-user-authentication");
        ParsingUtils.setPropertyValue(element, poolBuilder, "ping-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "pr-single-hop-enabled");
        ParsingUtils.setPropertyValue(element, poolBuilder, "read-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "retry-attempts");
        ParsingUtils.setPropertyValue(element, poolBuilder, "server-group");
        ParsingUtils.setPropertyValue(element, poolBuilder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, poolBuilder, "socket-connect-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "statistic-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-ack-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-enabled");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-message-tracking-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-redundancy");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-timeout-multiplier");
        ParsingUtils.setPropertyValue(element, poolBuilder, "thread-local-connections");
        List childElements = DomUtils.getChildElements((Element)element);
        ManagedList locators = new ManagedList(childElements.size());
        ManagedList servers = new ManagedList(childElements.size());
        CollectionUtils.nullSafeList(childElements).forEach(childElement -> {
            String childElementName = childElement.getLocalName();
            if (LOCATOR_ELEMENT_NAME.equals(childElementName)) {
                locators.add((Object)this.parseLocator((Element)childElement));
            }
            if (SERVER_ELEMENT_NAME.equals(childElementName)) {
                servers.add((Object)this.parseServer((Element)childElement));
            }
        });
        BeanDefinitionRegistry registry = this.resolveRegistry(parserContext);
        boolean locatorsSet = this.parseLocators(element, poolBuilder, registry);
        boolean serversSet = this.parseServers(element, poolBuilder, registry);
        if (childElements.isEmpty() && !locatorsSet && !serversSet) {
            servers.add((Object)this.buildConnection(DEFAULT_HOST, String.valueOf(40404), true));
        }
        if (!locators.isEmpty()) {
            poolBuilder.addPropertyValue(LOCATORS_ATTRIBUTE_NAME, (Object)locators);
        }
        if (!servers.isEmpty()) {
            poolBuilder.addPropertyValue(SERVERS_ATTRIBUTE_NAME, (Object)servers);
        }
    }

    BeanDefinitionRegistry resolveRegistry(ParserContext parserContext) {
        return parserContext.getRegistry();
    }

    BeanDefinition buildConnection(String host, String port, boolean server) {
        BeanDefinitionBuilder connectionEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpoint.class);
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultHost(host));
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultPort(port, server));
        return connectionEndpointBuilder.getBeanDefinition();
    }

    BeanDefinition buildConnections(String expression, boolean server) {
        BeanDefinitionBuilder connectionEndpointListBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpointList.class);
        connectionEndpointListBuilder.setFactoryMethod("parse");
        connectionEndpointListBuilder.addConstructorArgValue((Object)this.defaultPort(null, server));
        connectionEndpointListBuilder.addConstructorArgValue((Object)expression);
        return connectionEndpointListBuilder.getBeanDefinition();
    }

    String defaultHost(String host) {
        return StringUtils.hasText((String)host) ? host : DEFAULT_HOST;
    }

    String defaultPort(String port, boolean server) {
        return StringUtils.hasText((String)port) ? port : (server ? String.valueOf(40404) : String.valueOf(10334));
    }

    BeanDefinition parseLocator(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), false);
    }

    boolean parseLocators(Element element, BeanDefinitionBuilder poolBuilder, BeanDefinitionRegistry registry) {
        String locatorsAttributeValue = element.getAttribute(LOCATORS_ATTRIBUTE_NAME);
        if (StringUtils.hasText((String)locatorsAttributeValue)) {
            BeanDefinitionBuilder addLocatorsMethodInvokingBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingBean.class);
            addLocatorsMethodInvokingBeanBuilder.addPropertyReference("targetObject", this.resolveDereferencedId(element));
            addLocatorsMethodInvokingBeanBuilder.addPropertyValue("targetMethod", (Object)"addLocators");
            addLocatorsMethodInvokingBeanBuilder.addPropertyValue("arguments", (Object)this.buildConnections(locatorsAttributeValue, false));
            AbstractBeanDefinition addLocatorsMethodInvokingBean = addLocatorsMethodInvokingBeanBuilder.getBeanDefinition();
            poolBuilder.addPropertyReference("locatorsConfiguration", BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)addLocatorsMethodInvokingBean, (BeanDefinitionRegistry)registry));
            return true;
        }
        return false;
    }

    BeanDefinition parseServer(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), true);
    }

    boolean parseServers(Element element, BeanDefinitionBuilder poolBuilder, BeanDefinitionRegistry registry) {
        String serversAttributeValue = element.getAttribute(SERVERS_ATTRIBUTE_NAME);
        if (StringUtils.hasText((String)serversAttributeValue)) {
            BeanDefinitionBuilder addServersMethodInvokingBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingBean.class);
            addServersMethodInvokingBeanBuilder.addPropertyReference("targetObject", this.resolveDereferencedId(element));
            addServersMethodInvokingBeanBuilder.addPropertyValue("targetMethod", (Object)"addServers");
            addServersMethodInvokingBeanBuilder.addPropertyValue("arguments", (Object)this.buildConnections(serversAttributeValue, true));
            AbstractBeanDefinition addServersMethodInvokingBean = addServersMethodInvokingBeanBuilder.getBeanDefinition();
            poolBuilder.addPropertyReference("serversConfiguration", BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)addServersMethodInvokingBean, (BeanDefinitionRegistry)registry));
            return true;
        }
        return false;
    }

    String resolveId(Element element) {
        return Optional.ofNullable(element.getAttribute("id")).filter(StringUtils::hasText).orElse("gemfirePool");
    }

    String resolveDereferencedId(Element element) {
        return SpringUtils.dereferenceBean(this.resolveId(element));
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = "gemfirePool";
            parserContext.getRegistry().registerAlias("gemfirePool", "gemfire-pool");
        }
        return id;
    }
}

