/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableGatewaySender;
import org.springframework.data.gemfire.config.annotation.GatewaySenderConfigurer;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposableGatewaySenderConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.wan.GatewaySenderFactoryBean;
import org.springframework.data.gemfire.wan.OrderPolicyType;
import org.springframework.util.StringUtils;

@Configuration
public class GatewaySenderConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    static final int DEFAULT_SOCKET_BUFFER_SIZE = 524288;
    static final boolean DEFAULT_MANUAL_START = false;
    static final boolean DEFAULT_DISK_SYNCHRONOUS = true;
    static final boolean DEFAULT_BATCH_CONFLATION_ENABLED = false;
    static final boolean DEFAULT_PARALLEL = false;
    static final boolean DEFAULT_PERSISTENT = false;
    static final int DEFAULT_ALERT_THRESHOLD = 0;
    static final int DEFAULT_BATCH_SIZE = 100;
    static final int DEFAULT_BATCH_TIME_INTERVAL = 1000;
    static final int DEFAULT_DISPATCHER_THREADS = 5;
    static final int DEFAULT_MAXIMUM_QUEUE_MEMORY = 100;
    static final int DEFAULT_REMOTE_DISTRIBUTED_SYSTEM_ID = -1;
    static final int DEFAULT_SOCKET_READ_TIMEOUT = 0;
    static final OrderPolicyType DEFAULT_ORDER_POLICY = OrderPolicyType.KEY;
    static final String DEFAULT_DISK_STORE_REFERENCE = "";
    static final String DEFAULT_EVENT_SUBSTITUTION_FILTER = "";
    static final String DEFAULT_NAME = "GatewaySender";
    static final String[] DEFAULT_EVENT_FILTERS = new String[0];
    static final String[] DEFAULT_TRANSPORT_FILTERS = new String[0];
    static final String[] DEFAULT_REGION_NAMES = new String[0];
    static final String REGION_NAMES_LITERAL = "regions";
    private static final String ALERT_THRESHOLD_LITERAL = "alertThreshold";
    private static final String BATCH_CONFLATION_ENABLED_LITERAL = "batchConflationEnabled";
    private static final String BATCH_SIZE_LITERAL = "batchSize";
    private static final String BATCH_TIME_INTERVAL_LITERAL = "batchTimeInterval";
    private static final String DISK_STORE_REFERENCE_LITERAL = "diskStoreReference";
    private static final String DISK_SYNCHRONOUS_LITERAL = "diskSynchronous";
    private static final String DISPATCHER_THREAD_LITERAL = "dispatcherThreads";
    private static final String EVENT_FILTERS_LITERAL = "eventFilters";
    private static final String EVENT_SUBSTITUTION_FILTER_LITERAL = "eventSubstitutionFilter";
    private static final String MANUAL_START_LITERAL = "manualStart";
    private static final String MAXIMUM_QUEUE_MEMORY_LITERAL = "maximumQueueMemory";
    private static final String NAME_LITERAL = "name";
    private static final String ORDER_POLICY_LITERAL = "orderPolicy";
    private static final String PARALLEL_LITERAL = "parallel";
    private static final String PERSISTENT_LITERAL = "persistent";
    private static final String REMOTE_DIST_SYSTEM_ID_LITERAL = "remoteDistributedSystemId";
    private static final String SOCKET_BUFFER_SIZE_LITERAL = "socketBufferSize";
    private static final String SOCKET_READ_TIMEOUT_LITERAL = "socketReadTimeout";
    private static final String TRANSPORT_FILTERS_LITERAL = "transportFilters";
    private static final String ALERT_THRESHOLD_PROPERTY_NAME = "alert-threshold";
    private static final String BATCH_CONFLATION_ENABLED_PROPERTY_NAME = "batch-conflation-enabled";
    private static final String BATCH_SIZE_PROPERTY_NAME = "batch-size";
    private static final String BATCH_TIME_INTERVAL_PROPERTY_NAME = "batch-time-interval";
    private static final String DISK_STORE_REFERENCE_PROPERTY_NAME = "disk-store-reference";
    private static final String DISK_SYNCHRONOUS_PROPERTY_NAME = "disk-synchronous";
    private static final String DISPATCHER_THREAD_PROPERTY_NAME = "dispatcher-threads";
    private static final String EVENT_FILTERS_PROPERTY_NAME = "event-filters";
    private static final String EVENT_SUBSTITUTION_FILTER_PROPERTY_NAME = "event-substitution-filter";
    private static final String MANUAL_START_PROPERTY_NAME = "manual-start";
    private static final String MAXIMUM_QUEUE_MEMORY_PROPERTY_NAME = "maximum-queue-memory";
    private static final String ORDER_POLICY_PROPERTY_NAME = "order-policy";
    private static final String PARALLEL_PROPERTY_NAME = "parallel";
    private static final String PERSISTENT_PROPERTY_NAME = "persistent";
    private static final String REGION_NAMES_PROPERTY_NAME = "regions";
    private static final String REMOTE_DIST_SYSTEM_ID_PROPERTY_NAME = "remote-distributed-system-id";
    private static final String SOCKET_BUFFER_SIZE_PROPERTY_NAME = "socket-buffer-size";
    private static final String SOCKET_READ_TIMEOUT_PROPERTY_NAME = "socket-read-timeout";
    private static final String TRANSPORT_FILTERS_PROPERTY_NAME = "transport-filters";
    @Autowired(required=false)
    private List<GatewaySenderConfigurer> gatewaySenderConfigurers = Collections.emptyList();
    private String gatewaySenderBeanName;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableGatewaySender.class;
    }

    protected void setGatewaySenderBeanName(String gatewaySenderBeanName) {
        this.gatewaySenderBeanName = gatewaySenderBeanName;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        if (this.isAnnotationPresent(annotationMetadata)) {
            AnnotationAttributes gatewaySenderAnnotation = this.getAnnotationAttributes(annotationMetadata);
            this.registerGatewaySender(gatewaySenderAnnotation, null, beanDefinitionRegistry);
        }
    }

    protected void registerGatewaySender(AnnotationAttributes gatewaySenderAnnotation, AnnotationAttributes parentGatewaySenderAnnotation, BeanDefinitionRegistry registry) {
        String gatewaySenderName = this.getStringFromAnnotation(gatewaySenderAnnotation, NAME_LITERAL);
        this.registerGatewaySender(gatewaySenderName, gatewaySenderAnnotation, parentGatewaySenderAnnotation, registry);
    }

    protected void registerGatewaySender(String gatewaySenderName, AnnotationAttributes gatewaySenderAnnotation, AnnotationAttributes parentGatewaySenderAnnotation, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder gatewaySenderBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewaySenderFactoryBean.class);
        this.configureGatewaySenderFromAnnotation(gatewaySenderName, gatewaySenderAnnotation, parentGatewaySenderAnnotation, gatewaySenderBuilder);
        this.configureGatewaySenderFromProperties(gatewaySenderName, gatewaySenderBuilder);
        this.configureGatewaySenderArguments(gatewaySenderName, gatewaySenderAnnotation, parentGatewaySenderAnnotation, gatewaySenderBuilder);
        registry.registerBeanDefinition(gatewaySenderName, (BeanDefinition)gatewaySenderBuilder.getBeanDefinition());
    }

    private void configureGatewaySenderArguments(String gatewaySenderName, AnnotationAttributes gatewaySenderAnnotation, AnnotationAttributes parentGatewaySenderAnnotation, BeanDefinitionBuilder gatewaySenderBuilder) {
        String[] annotationRegionNames = Optional.ofNullable(this.getStringArrayFromAnnotation(gatewaySenderAnnotation, "regions")).filter(ArrayUtils::isNotEmpty).orElseGet(() -> Optional.ofNullable(this.getStringArrayFromAnnotation(parentGatewaySenderAnnotation, "regions")).filter(ArrayUtils::isNotEmpty).orElse(DEFAULT_REGION_NAMES));
        String[] resolvedRegionNames = Optional.ofNullable(this.resolveValueFromProperty(gatewaySenderName, "regions", annotationRegionNames)).filter(ArrayUtils::isNotEmpty).orElse(annotationRegionNames);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, "regions", resolvedRegionNames, null, DEFAULT_REGION_NAMES);
    }

    private void configureGatewaySenderFromAnnotation(String gatewaySenderName, AnnotationAttributes gatewaySenderAnnotation, AnnotationAttributes parentGatewaySenderAnnotation, BeanDefinitionBuilder gatewaySenderBuilder) {
        this.setGatewaySenderBeanName(Optional.ofNullable(gatewaySenderName).orElse(DEFAULT_NAME));
        this.setPropertyValueIfNotDefault(gatewaySenderBuilder, NAME_LITERAL, gatewaySenderName, DEFAULT_NAME);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, ALERT_THRESHOLD_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, ALERT_THRESHOLD_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, ALERT_THRESHOLD_LITERAL), 0);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, BATCH_CONFLATION_ENABLED_LITERAL, this.getBooleanFromAnnotation(gatewaySenderAnnotation, BATCH_CONFLATION_ENABLED_LITERAL), this.getBooleanFromAnnotation(parentGatewaySenderAnnotation, BATCH_CONFLATION_ENABLED_LITERAL), false);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, BATCH_SIZE_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, BATCH_SIZE_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, BATCH_SIZE_LITERAL), 100);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, BATCH_TIME_INTERVAL_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, BATCH_TIME_INTERVAL_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, BATCH_TIME_INTERVAL_LITERAL), 1000);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, DISK_STORE_REFERENCE_LITERAL, this.getStringFromAnnotation(gatewaySenderAnnotation, DISK_STORE_REFERENCE_LITERAL), this.getStringFromAnnotation(parentGatewaySenderAnnotation, DISK_STORE_REFERENCE_LITERAL), "");
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, DISK_SYNCHRONOUS_LITERAL, this.getBooleanFromAnnotation(gatewaySenderAnnotation, DISK_SYNCHRONOUS_LITERAL), this.getBooleanFromAnnotation(parentGatewaySenderAnnotation, DISK_SYNCHRONOUS_LITERAL), true);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, DISPATCHER_THREAD_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, DISPATCHER_THREAD_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, DISPATCHER_THREAD_LITERAL), 5);
        this.setPropertyValueOrUseParentAsBeanReferenceList(gatewaySenderBuilder, EVENT_FILTERS_LITERAL, this.getStringArrayFromAnnotation(gatewaySenderAnnotation, EVENT_FILTERS_LITERAL), this.getStringArrayFromAnnotation(parentGatewaySenderAnnotation, EVENT_FILTERS_LITERAL), DEFAULT_EVENT_FILTERS);
        this.setPropertyValueIfNotDefaultAsBeanReference(gatewaySenderBuilder, EVENT_SUBSTITUTION_FILTER_LITERAL, this.getStringFromAnnotation(gatewaySenderAnnotation, EVENT_SUBSTITUTION_FILTER_LITERAL), this.getStringFromAnnotation(parentGatewaySenderAnnotation, EVENT_SUBSTITUTION_FILTER_LITERAL), "");
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, MANUAL_START_LITERAL, this.getBooleanFromAnnotation(gatewaySenderAnnotation, MANUAL_START_LITERAL), this.getBooleanFromAnnotation(parentGatewaySenderAnnotation, MANUAL_START_LITERAL), false);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, MAXIMUM_QUEUE_MEMORY_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, MAXIMUM_QUEUE_MEMORY_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, MAXIMUM_QUEUE_MEMORY_LITERAL), 100);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, ORDER_POLICY_LITERAL, this.getEnumFromAnnotation(gatewaySenderAnnotation, ORDER_POLICY_LITERAL, DEFAULT_ORDER_POLICY).toString(), this.getEnumFromAnnotation(parentGatewaySenderAnnotation, ORDER_POLICY_LITERAL, DEFAULT_ORDER_POLICY).toString(), DEFAULT_ORDER_POLICY.toString());
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, "parallel", this.getBooleanFromAnnotation(gatewaySenderAnnotation, "parallel"), this.getBooleanFromAnnotation(parentGatewaySenderAnnotation, "parallel"), false);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, "persistent", this.getBooleanFromAnnotation(gatewaySenderAnnotation, "persistent"), this.getBooleanFromAnnotation(parentGatewaySenderAnnotation, "persistent"), false);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, REMOTE_DIST_SYSTEM_ID_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, REMOTE_DIST_SYSTEM_ID_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, REMOTE_DIST_SYSTEM_ID_LITERAL), -1);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, SOCKET_BUFFER_SIZE_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, SOCKET_BUFFER_SIZE_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, SOCKET_BUFFER_SIZE_LITERAL), 524288);
        this.setPropertyValueOrUseParent(gatewaySenderBuilder, SOCKET_READ_TIMEOUT_LITERAL, this.getNumberFromAnnotation(gatewaySenderAnnotation, SOCKET_READ_TIMEOUT_LITERAL), this.getNumberFromAnnotation(parentGatewaySenderAnnotation, SOCKET_READ_TIMEOUT_LITERAL), 0);
        this.setPropertyValueOrUseParentAsBeanReferenceList(gatewaySenderBuilder, TRANSPORT_FILTERS_LITERAL, this.getStringArrayFromAnnotation(gatewaySenderAnnotation, TRANSPORT_FILTERS_LITERAL), this.getStringArrayFromAnnotation(parentGatewaySenderAnnotation, TRANSPORT_FILTERS_LITERAL), DEFAULT_TRANSPORT_FILTERS);
    }

    private void configureGatewaySenderFromProperties(String gatewaySenderName, BeanDefinitionBuilder gatewaySenderBuilder) {
        gatewaySenderBuilder.addPropertyValue("gatewaySenderConfigurers", this.resolveGatewaySenderConfigurers());
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, ALERT_THRESHOLD_PROPERTY_NAME, ALERT_THRESHOLD_LITERAL, 0);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, BATCH_CONFLATION_ENABLED_PROPERTY_NAME, BATCH_CONFLATION_ENABLED_LITERAL, false);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, BATCH_SIZE_PROPERTY_NAME, BATCH_SIZE_LITERAL, 100);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, BATCH_TIME_INTERVAL_PROPERTY_NAME, BATCH_TIME_INTERVAL_LITERAL, 1000);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, DISK_STORE_REFERENCE_PROPERTY_NAME, DISK_STORE_REFERENCE_LITERAL, new String[0]);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, DISK_SYNCHRONOUS_PROPERTY_NAME, DISK_SYNCHRONOUS_LITERAL, true);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, DISPATCHER_THREAD_PROPERTY_NAME, DISPATCHER_THREAD_LITERAL, 5);
        this.configureBeanReferenceListFromProperty(gatewaySenderBuilder, gatewaySenderName, EVENT_FILTERS_PROPERTY_NAME, EVENT_FILTERS_LITERAL, DEFAULT_EVENT_FILTERS);
        this.configureBeanReferenceFromProperty(gatewaySenderBuilder, gatewaySenderName, EVENT_SUBSTITUTION_FILTER_PROPERTY_NAME, EVENT_SUBSTITUTION_FILTER_LITERAL, "");
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, MANUAL_START_PROPERTY_NAME, MANUAL_START_LITERAL, false);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, MAXIMUM_QUEUE_MEMORY_PROPERTY_NAME, MAXIMUM_QUEUE_MEMORY_LITERAL, 100);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, ORDER_POLICY_PROPERTY_NAME, ORDER_POLICY_LITERAL, DEFAULT_ORDER_POLICY.toString());
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, "parallel", "parallel", false);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, "persistent", "persistent", false);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, REMOTE_DIST_SYSTEM_ID_PROPERTY_NAME, REMOTE_DIST_SYSTEM_ID_LITERAL, -1);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, SOCKET_BUFFER_SIZE_PROPERTY_NAME, SOCKET_BUFFER_SIZE_LITERAL, 524288);
        this.configureGatewaySenderFromProperty(gatewaySenderBuilder, gatewaySenderName, SOCKET_READ_TIMEOUT_PROPERTY_NAME, SOCKET_READ_TIMEOUT_LITERAL, 0);
        this.configureBeanReferenceListFromProperty(gatewaySenderBuilder, gatewaySenderName, TRANSPORT_FILTERS_PROPERTY_NAME, TRANSPORT_FILTERS_LITERAL, DEFAULT_TRANSPORT_FILTERS);
    }

    private <T> void configureGatewaySenderFromProperty(BeanDefinitionBuilder gatewaySenderBuilder, String gatewaySenderName, String propertyName, String fieldName, T defaultValue) {
        T resolvedPropertyValue = this.resolveValueFromProperty(gatewaySenderName, propertyName, defaultValue);
        if (resolvedPropertyValue != null) {
            this.setPropertyValueOrUseParent(gatewaySenderBuilder, fieldName, resolvedPropertyValue, null, defaultValue);
        }
    }

    private Boolean getBooleanFromAnnotation(AnnotationAttributes gatewaySenderAnnotation, String annotationLabel) {
        return this.getValueFromAnnotation(gatewaySenderAnnotation, () -> gatewaySenderAnnotation.getBoolean(annotationLabel));
    }

    private Enum<?> getEnumFromAnnotation(AnnotationAttributes gatewaySenderAnnotation, String annotationLabel, Enum<?> defaultValue) {
        return this.getValueFromAnnotation(gatewaySenderAnnotation, () -> gatewaySenderAnnotation.getEnum(annotationLabel), defaultValue);
    }

    private Integer getNumberFromAnnotation(AnnotationAttributes gatewaySenderAnnotation, String annotationLabel) {
        return this.getValueFromAnnotation(gatewaySenderAnnotation, () -> (Integer)gatewaySenderAnnotation.getNumber(annotationLabel));
    }

    private String getStringFromAnnotation(AnnotationAttributes gatewaySenderAnnotation, String annotationLabel) {
        return this.getValueFromAnnotation(gatewaySenderAnnotation, () -> gatewaySenderAnnotation.getString(annotationLabel));
    }

    private String[] getStringArrayFromAnnotation(AnnotationAttributes gatewaySenderAnnotation, String annotationLabel) {
        return this.getValueFromAnnotation(gatewaySenderAnnotation, () -> gatewaySenderAnnotation.getStringArray(annotationLabel));
    }

    private <T> T getValueFromAnnotation(AnnotationAttributes gatewaySenderAnnotation, Supplier<T> supplier) {
        return gatewaySenderAnnotation != null ? (T)supplier.get() : null;
    }

    private <T> T getValueFromAnnotation(AnnotationAttributes gatewaySenderAnnotation, Supplier<T> supplier, T defaultValue) {
        return gatewaySenderAnnotation != null ? supplier.get() : defaultValue;
    }

    private void configureBeanReferenceFromProperty(BeanDefinitionBuilder gatewaySenderBeanBuilder, String gatewaySenderName, String propertyName, String fieldName, String defaultValue) {
        String resolvedPropertyValue = this.resolveValueFromProperty(gatewaySenderName, propertyName, defaultValue);
        if (resolvedPropertyValue != null) {
            this.setPropertyValueIfNotDefaultAsBeanReference(gatewaySenderBeanBuilder, fieldName, resolvedPropertyValue, null, defaultValue);
        }
    }

    private void configureBeanReferenceListFromProperty(BeanDefinitionBuilder gatewaySenderBeanBuilder, String gatewaySenderName, String propertyName, String fieldName, String[] defaultValue) {
        String[] resolvedPropertyValue = this.resolveValueFromProperty(gatewaySenderName, propertyName, defaultValue);
        if (resolvedPropertyValue != null) {
            this.setPropertyValueOrUseParentAsBeanReferenceList(gatewaySenderBeanBuilder, fieldName, resolvedPropertyValue, new String[0], defaultValue);
        }
    }

    private List<GatewaySenderConfigurer> resolveGatewaySenderConfigurers() {
        return Optional.ofNullable(this.gatewaySenderConfigurers).filter(gatewaySenderConfigurers -> !gatewaySenderConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposableGatewaySenderConfigurer.create(this.getBeanFactory())));
    }

    private <T> T resolveValueFromProperty(String gatewaySenderName, String propertyName, T defaultValue) {
        Class<?> type = defaultValue.getClass();
        T gatewaySenderProperty = this.resolveProperty(this.gatewaySenderProperty(propertyName), type, null);
        T namedGatewaySenderProperty = this.resolveProperty(this.namedGatewaySenderProperty(gatewaySenderName, propertyName), type, null);
        return namedGatewaySenderProperty != null ? namedGatewaySenderProperty : gatewaySenderProperty;
    }

    private <T> BeanDefinitionBuilder setPropertyValueIfNotDefault(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T defaultValue) {
        return beanDefinitionBuilder.addPropertyValue(propertyName, Optional.ofNullable(value).orElse(defaultValue));
    }

    private <T> BeanDefinitionBuilder setPropertyValueOrUseParent(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T parentValue, T defaultValue) {
        Object resolvedValue = Optional.ofNullable(value).filter(childValue -> !childValue.equals(defaultValue)).orElseGet(() -> Optional.ofNullable(parentValue).orElse(defaultValue));
        return beanDefinitionBuilder.addPropertyValue(propertyName, resolvedValue);
    }

    private BeanDefinitionBuilder setPropertyValueIfNotDefaultAsBeanReference(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, String value, String parentValue, String defaultValue) {
        if (!StringUtils.isEmpty((Object)value)) {
            return beanDefinitionBuilder.addPropertyReference(propertyName, value);
        }
        if (!StringUtils.isEmpty((Object)parentValue)) {
            return beanDefinitionBuilder.addPropertyReference(propertyName, parentValue);
        }
        if (!StringUtils.isEmpty((Object)defaultValue)) {
            beanDefinitionBuilder.addPropertyReference(propertyName, defaultValue);
        }
        return beanDefinitionBuilder;
    }

    private BeanDefinitionBuilder setPropertyValueOrUseParentAsBeanReferenceList(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, String[] values, String[] parentValues, String[] defaultList) {
        String[] resolvedList = Optional.ofNullable(values).filter(it -> !Arrays.equals(it, defaultList)).orElseGet(() -> Optional.ofNullable(parentValues).orElse(defaultList));
        ManagedList beanReferences = new ManagedList();
        Arrays.stream(resolvedList).map(RuntimeBeanReference::new).forEach(arg_0 -> beanReferences.add(arg_0));
        return beanDefinitionBuilder.addPropertyValue(propertyName, (Object)beanReferences);
    }
}

