/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Optional;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.data.gemfire.client.support.PoolManagerPoolResolver;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.data.gemfire.function.execution.AbstractFunctionTemplate;
import org.springframework.data.gemfire.function.execution.PoolServersFunctionExecution;
import org.springframework.data.gemfire.function.execution.ServersFunctionExecution;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemfireOnServersFunctionTemplate
extends AbstractFunctionTemplate {
    protected static final PoolResolver DEFAULT_POOL_RESOLVER = new PoolManagerPoolResolver();
    private Pool pool;
    private PoolResolver poolResolver = DEFAULT_POOL_RESOLVER;
    private final RegionService cache;
    private String poolName;

    public GemfireOnServersFunctionTemplate(RegionService cache) {
        Assert.notNull((Object)cache, (String)"RegionService must not be null");
        this.cache = cache;
    }

    public GemfireOnServersFunctionTemplate(Pool pool) {
        this.cache = this.resolveClientCache();
        this.pool = pool;
    }

    public GemfireOnServersFunctionTemplate(String poolName) {
        this.cache = this.resolveClientCache();
        this.poolName = poolName;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setPoolResolver(PoolResolver poolResolver) {
        this.poolResolver = poolResolver;
    }

    protected PoolResolver getPoolResolver() {
        PoolResolver poolResolver = this.poolResolver;
        return poolResolver != null ? poolResolver : DEFAULT_POOL_RESOLVER;
    }

    @Override
    protected AbstractFunctionExecution getFunctionExecution() {
        Object gemfireObject = this.resolveRequiredGemFireObject();
        return gemfireObject instanceof Pool ? new PoolServersFunctionExecution((Pool)gemfireObject) : new ServersFunctionExecution((RegionService)gemfireObject);
    }

    protected Object resolveRequiredGemFireObject() {
        return Optional.ofNullable(this.resolvePool()).orElseGet(this::resolveClientCache);
    }

    protected ClientCache resolveClientCache() {
        return Optional.ofNullable(CacheUtils.getClientCache()).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("No ClientCache instance is present", new Object[0]));
    }

    protected Pool resolveDefaultPool() {
        return Optional.ofNullable(this.getPoolResolver().resolve("DEFAULT")).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("No Pool was configured", new Object[0]));
    }

    protected Pool resolveNamedPool() {
        if (StringUtils.hasText((String)this.poolName)) {
            this.pool = Optional.ofNullable(this.getPoolResolver().resolve(this.poolName)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("No Pool with name [%s] exists", this.poolName));
        }
        return this.pool;
    }

    protected Pool resolvePool() {
        this.pool = Optional.ofNullable(this.pool).orElseGet(this::resolveNamedPool);
        return this.pool;
    }
}

